/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import krati.core.array.entry.AbstractEntry;
import krati.core.array.entry.EntryValue;
import krati.core.array.entry.EntryValueFactory;
import krati.io.DataReader;
import krati.io.DataWriter;

public abstract class PreFillEntry<T extends EntryValue>
extends AbstractEntry<T> {
    protected int _index = 0;
    protected final ArrayList<T> _valArray;

    public PreFillEntry(int entryId, EntryValueFactory<T> valFactory, int initialCapacity) {
        super(entryId, valFactory, initialCapacity);
        this._valArray = new ArrayList(initialCapacity);
        for (int i = 0; i < initialCapacity; ++i) {
            this._valArray.add(this._valFactory.newValue());
        }
        this._index = 0;
    }

    @Override
    public final int size() {
        return this._index;
    }

    @Override
    public void clear() {
        super.clear();
        this._index = 0;
    }

    @Override
    public List<T> getValueList() {
        return this._valArray.subList(0, this._index);
    }

    @Override
    protected void loadDataSection(DataReader in, int cnt) throws IOException {
        this.ensureCapacity(cnt);
        for (int i = 0; i < cnt; ++i) {
            this.add(this._valFactory.newValue(in));
        }
    }

    @Override
    protected void saveDataSection(DataWriter out) throws IOException {
        for (EntryValue val : this.getValueList()) {
            val.write(out);
        }
    }

    protected void ensureCapacity(int newCapacity) {
        if (newCapacity > this._entryCapacity) {
            int cnt = newCapacity - this._entryCapacity;
            for (int i = 0; i < cnt; ++i) {
                this._valArray.add(this._valFactory.newValue());
            }
            this._entryCapacity = newCapacity;
        }
    }
}

