/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

public final class AddressFormat {
    private final int _numDataSizeBits;
    private final int _numSegmentBits;
    private final int _numOffsetBits;
    private final int _dataSizeShift;
    private final int _dataSizeMask;
    private final int _segmentMask;
    private final int _offsetMask;
    private final int _maxDataSize;

    public AddressFormat() {
        this(32, 16);
    }

    protected AddressFormat(int numOffsetBits, int numSegmentBits) {
        if (numOffsetBits < 1 || 32 < numOffsetBits) {
            throw new IllegalArgumentException("Invalid numOffsetBits: " + numOffsetBits);
        }
        if (numSegmentBits < 1 || 31 < numSegmentBits) {
            throw new IllegalArgumentException("Invalid numSegmentBits: " + numSegmentBits);
        }
        this._numOffsetBits = numOffsetBits;
        this._numSegmentBits = numSegmentBits;
        this._numDataSizeBits = 64 - this._numSegmentBits - this._numOffsetBits;
        this._offsetMask = numOffsetBits >= 31 ? Integer.MAX_VALUE : (1 << this._numOffsetBits) - 1;
        this._segmentMask = (1 << this._numSegmentBits) - 1;
        this._maxDataSize = this._dataSizeMask = (1 << this._numDataSizeBits) - 1;
        this._dataSizeShift = this._numSegmentBits + this._numOffsetBits;
    }

    public final int countOffsetBits() {
        return this._numOffsetBits;
    }

    public final int countSegmentBits() {
        return this._numSegmentBits;
    }

    public final int countDataSizeBits() {
        return this._numDataSizeBits;
    }

    public final int getDataSizeShift() {
        return this._dataSizeShift;
    }

    public final int getDataSizeMask() {
        return this._dataSizeMask;
    }

    public final int getSegmentShift() {
        return this._numOffsetBits;
    }

    public final int getSegmentMask() {
        return this._segmentMask;
    }

    public final int getOffsetShift() {
        return 0;
    }

    public final int getOffsetMask() {
        return this._offsetMask;
    }

    public final int getOffset(long addr) {
        return (int)(addr & (long)this._offsetMask);
    }

    public final int getSegment(long addr) {
        return (int)(addr >> this._numOffsetBits) & this._segmentMask;
    }

    public final int getDataSize(long addr) {
        return (int)(addr >> this._dataSizeShift) & this._dataSizeMask;
    }

    public final int getMaxDataSize() {
        return this._maxDataSize;
    }

    public final long composeAddress(int offset, int segment, int dataSize) {
        if (dataSize > this._maxDataSize) {
            return (long)offset | (long)segment << this._numOffsetBits;
        }
        return (long)offset | (long)segment << this._numOffsetBits | (long)dataSize << this._dataSizeShift;
    }

    public final String toString(long address) {
        long offset = this.getOffset(address);
        long segment = this.getSegment(address);
        long dataSize = this.getDataSize(address);
        return String.format("Address=%d [offset=%d segment=%d size=%d]", address, offset, segment, dataSize);
    }
}

