/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import krati.core.segment.AbstractSegment;
import krati.core.segment.Segment;
import krati.core.segment.SegmentOverflowException;
import krati.core.segment.SegmentReadOnlyException;
import org.apache.log4j.Logger;

public class ChannelSegment
extends AbstractSegment {
    private static final Logger _log = Logger.getLogger(ChannelSegment.class);

    public ChannelSegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode) throws IOException {
        super(segmentId, segmentFile, initialSizeMB, mode);
    }

    @Override
    protected void init() throws IOException {
        if (!this.getSegmentFile().exists()) {
            if (!this.getSegmentFile().createNewFile()) {
                String msg = "Failed to create " + this.getSegmentFile().getAbsolutePath();
                _log.error((Object)msg);
                throw new IOException(msg);
            }
            RandomAccessFile raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            raf.setLength(this.getInitialSize());
            raf.close();
        }
        if (this.getMode() == Segment.Mode.READ_ONLY) {
            this._raf = new RandomAccessFile(this.getSegmentFile(), "r");
            this.checkSegmentSize();
            this._channel = this._raf.getChannel();
            this._channel.position(0L);
            this.loadHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " loaded: " + this.getHeader()));
        } else {
            this._raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            this.checkSegmentSize();
            this._channel = this._raf.getChannel();
            this._channel.position(0L);
            this.initHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " initialized: " + this.getStatus()));
        }
    }

    @Override
    public long getAppendPosition() throws IOException {
        return this._channel.position();
    }

    @Override
    public void setAppendPosition(long newPosition) throws IOException {
        this._channel.position(newPosition);
    }

    @Override
    public int appendInt(int value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = (int)this._channel.position();
            if ((long)(pos + 4) >= this._initSizeBytes) {
                throw new BufferOverflowException();
            }
            ByteBuffer bb = ByteBuffer.wrap(new byte[4]);
            bb.putInt(value);
            bb.flip();
            this._channel.write(bb);
            this.incrLoadSize(4);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int appendLong(long value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = (int)this._channel.position();
            if ((long)(pos + 8) >= this._initSizeBytes) {
                throw new BufferOverflowException();
            }
            ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
            bb.putLong(value);
            bb.flip();
            this._channel.write(bb);
            this.incrLoadSize(8);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int appendShort(short value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = (int)this._channel.position();
            if ((long)(pos + 2) >= this._initSizeBytes) {
                throw new BufferOverflowException();
            }
            ByteBuffer bb = ByteBuffer.wrap(new byte[2]);
            bb.putShort(value);
            bb.flip();
            this._channel.write(bb);
            this.incrLoadSize(2);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int append(byte[] data) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = (int)this._channel.position();
            if ((long)(pos + data.length) >= this._initSizeBytes) {
                throw new BufferOverflowException();
            }
            ByteBuffer bb = ByteBuffer.wrap(data);
            this._channel.write(bb);
            this.incrLoadSize(data.length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int append(byte[] data, int offset, int length) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = (int)this._channel.position();
            if ((long)(pos + length) >= this._initSizeBytes) {
                throw new BufferOverflowException();
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            this._channel.write(bb);
            this.incrLoadSize(length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int readInt(int pos) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(new byte[4]);
        this._channel.read(bb, pos);
        return bb.getInt(0);
    }

    @Override
    public long readLong(int pos) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
        this._channel.read(bb, pos);
        return bb.getLong(0);
    }

    @Override
    public short readShort(int pos) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(new byte[2]);
        this._channel.read(bb, pos);
        return bb.getShort(0);
    }

    @Override
    public void read(int pos, byte[] dst) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(dst);
        this._channel.read(bb, pos);
    }

    @Override
    public void read(int pos, byte[] dst, int offset, int length) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(dst, offset, length);
        this._channel.read(bb, pos);
    }

    @Override
    public int transferTo(int pos, int length, Segment targetSegment) throws IOException {
        if ((long)(pos + length) <= this._initSizeBytes) {
            byte[] dst = new byte[length];
            this.read(pos, dst);
            targetSegment.append(dst);
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    @Override
    public int transferTo(int pos, int length, WritableByteChannel targetChannel) throws IOException {
        return (int)this._channel.transferTo(pos, length, targetChannel);
    }

    @Override
    public synchronized void asReadOnly() throws IOException {
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            this.force();
            this._segMode = Segment.Mode.READ_ONLY;
            _log.info((Object)("Segment " + this.getSegmentId() + " switched to " + (Object)((Object)this.getMode())));
        }
    }

    @Override
    public synchronized void force() throws IOException {
        if (this._channel == null) {
            return;
        }
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            long currentTime = System.currentTimeMillis();
            ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
            bb.putLong(currentTime);
            bb.flip();
            this._channel.write(bb, 0L);
            this._lastForcedTime = currentTime;
        }
        this._channel.force(true);
        _log.info((Object)("Segment " + this.getSegmentId() + " forced: " + this.getStatus()));
    }

    @Override
    public synchronized void close(boolean force) throws IOException {
        if (force) {
            this.force();
        }
        if (this._channel != null) {
            this._channel.close();
            this._channel = null;
        }
        if (this._raf != null) {
            this._raf.close();
            this._raf = null;
        }
    }

    @Override
    public void reinit() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("reinit not supported");
    }

    @Override
    public boolean isRecyclable() {
        return false;
    }

    @Override
    public boolean canReadFromBuffer() {
        return false;
    }

    @Override
    public boolean canAppendToBuffer() {
        return false;
    }
}

