/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public interface Segment {
    public static final long STORAGE_VERSION = 1L;
    public static final double defaultSegmentCompactFactor = 0.5;
    public static final int defaultSegmentFileSizeMB = 256;
    public static final int maxSegmentFileSizeMB = 2048;
    public static final int minSegmentFileSizeMB = 8;
    public static final int posLastForcedTime = 0;
    public static final int posStorageVersion = 8;
    public static final int dataStartPosition = 128;

    public Mode getMode();

    public int getSegmentId();

    public File getSegmentFile();

    public long getInitialSize();

    public int getInitialSizeMB();

    public int getLoadSize();

    public double getLoadFactor();

    public void incrLoadSize(int var1);

    public void decrLoadSize(int var1);

    public long getAppendPosition() throws IOException;

    public void setAppendPosition(long var1) throws IOException;

    public int readInt(int var1) throws IOException;

    public long readLong(int var1) throws IOException;

    public short readShort(int var1) throws IOException;

    public void read(int var1, byte[] var2) throws IOException;

    public void read(int var1, byte[] var2, int var3, int var4) throws IOException;

    public int appendInt(int var1) throws IOException;

    public int appendLong(long var1) throws IOException;

    public int appendShort(short var1) throws IOException;

    public int append(byte[] var1) throws IOException;

    public int append(byte[] var1, int var2, int var3) throws IOException;

    public int transferTo(int var1, int var2, Segment var3) throws IOException;

    public int transferTo(int var1, int var2, WritableByteChannel var3) throws IOException;

    public boolean isReadOnly();

    public void asReadOnly() throws IOException;

    public void force() throws IOException;

    public void close(boolean var1) throws IOException;

    public long getLastForcedTime();

    public long getStorageVersion();

    public boolean isRecyclable();

    public boolean canReadFromBuffer();

    public boolean canAppendToBuffer();

    public void reinit() throws IOException;

    public String getStatus();

    public static enum Mode {
        READ_ONLY,
        READ_WRITE;

    }
}

