/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import krati.io.BasicIO;
import krati.io.DataWriter;

public class MappedWriter
implements DataWriter,
BasicIO {
    private final File _file;
    private FileChannel _channel;
    private RandomAccessFile _raf;
    private MappedByteBuffer _mmapBuffer;

    public MappedWriter(File file) {
        this._file = file;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public void open() throws IOException {
        if (!this._file.exists()) {
            File dir = this._file.getParentFile();
            if (dir.exists()) {
                this._file.createNewFile();
            } else if (dir.mkdirs()) {
                this._file.createNewFile();
            } else {
                throw new IOException("Failed to create file " + this._file.getAbsolutePath());
            }
        }
        if (this._file.isDirectory()) {
            throw new IOException("Cannot open directory " + this._file.getAbsolutePath());
        }
        this._raf = new RandomAccessFile(this._file, "rw");
        this._channel = this._raf.getChannel();
        this._mmapBuffer = this._channel.map(FileChannel.MapMode.READ_WRITE, 0L, this._raf.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this._mmapBuffer.force();
            this._channel.force(true);
            this._channel.close();
            this._raf.close();
        }
        finally {
            this._mmapBuffer = null;
            this._channel = null;
            this._raf = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this._channel.force(true);
    }

    @Override
    public void force() throws IOException {
        this._mmapBuffer.force();
    }

    @Override
    public void writeInt(int value) throws IOException {
        this._mmapBuffer.putInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this._mmapBuffer.putLong(value);
    }

    @Override
    public void writeShort(short value) throws IOException {
        this._mmapBuffer.putShort(value);
    }

    @Override
    public void writeInt(long position, int value) throws IOException {
        this._mmapBuffer.putInt((int)position, value);
    }

    @Override
    public void writeLong(long position, long value) throws IOException {
        this._mmapBuffer.putLong((int)position, value);
    }

    @Override
    public void writeShort(long position, short value) throws IOException {
        this._mmapBuffer.putShort((int)position, value);
    }

    @Override
    public long position() throws IOException {
        return this._mmapBuffer.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this._mmapBuffer.position((int)newPosition);
    }

    @Override
    public int readInt(long position) throws IOException {
        return this._mmapBuffer.getInt((int)position);
    }

    @Override
    public long readLong(long position) throws IOException {
        return this._mmapBuffer.getLong((int)position);
    }

    @Override
    public short readShort(long position) throws IOException {
        return this._mmapBuffer.getShort((int)position);
    }
}

