/*
 * Decompiled with CFR 0.152.
 */
package krati.io.serializer;

import java.nio.ByteOrder;
import krati.io.SerializationException;
import krati.io.Serializer;
import krati.util.Numbers;

public class IntSerializer
implements Serializer<Integer> {
    private final ByteOrder _byteOrder;

    public IntSerializer() {
        this._byteOrder = ByteOrder.BIG_ENDIAN;
    }

    public IntSerializer(ByteOrder byteOrder) {
        this._byteOrder = byteOrder == null ? ByteOrder.BIG_ENDIAN : byteOrder;
    }

    @Override
    public Integer deserialize(byte[] bytes) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.intValueBE(bytes) : Numbers.intValueLE(bytes);
    }

    @Override
    public byte[] serialize(Integer value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.intBytesBE(value) : Numbers.intBytesLE(value);
    }

    public int intValue(byte[] bytes) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.intValueBE(bytes) : Numbers.intValueLE(bytes);
    }

    public byte[] intBytes(int value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.intBytesBE(value) : Numbers.intBytesLE(value);
    }
}

