/*
 * Decompiled with CFR 0.152.
 */
package krati.io.serializer;

import java.nio.ByteOrder;
import krati.io.SerializationException;
import krati.io.Serializer;
import krati.util.Numbers;

public class LongSerializer
implements Serializer<Long> {
    private final ByteOrder _byteOrder;

    public LongSerializer() {
        this._byteOrder = ByteOrder.BIG_ENDIAN;
    }

    public LongSerializer(ByteOrder byteOrder) {
        this._byteOrder = byteOrder == null ? ByteOrder.BIG_ENDIAN : byteOrder;
    }

    @Override
    public Long deserialize(byte[] bytes) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.longValueBE(bytes) : Numbers.longValueLE(bytes);
    }

    @Override
    public byte[] serialize(Long value) throws SerializationException {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.longBytesBE(value) : Numbers.longBytesLE(value);
    }

    public long longValue(byte[] bytes) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.longValueBE(bytes) : Numbers.longValueLE(bytes);
    }

    public byte[] longBytes(long value) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Numbers.longBytesBE(value) : Numbers.longBytesLE(value);
    }
}

