/*
 * Decompiled with CFR 0.152.
 */
package krati.retention;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import krati.retention.Event;
import krati.retention.InvalidPositionException;
import krati.retention.Position;
import krati.retention.Retention;
import krati.retention.RetentionStoreReader;
import krati.retention.SimpleEvent;
import krati.retention.SimplePosition;
import krati.retention.clock.Clock;
import krati.store.DataStore;
import krati.util.IndexedIterator;
import org.apache.log4j.Logger;

public class SimpleRetentionStoreReader<K, V>
implements RetentionStoreReader<K, V> {
    private static final Logger _logger = Logger.getLogger(SimpleRetentionStoreReader.class);
    private final String _source;
    private final Retention<K> _retention;
    private final DataStore<K, V> _store;

    public SimpleRetentionStoreReader(String source, Retention<K> retention, DataStore<K, V> store) {
        this._source = source;
        this._retention = retention;
        this._store = store;
    }

    public final DataStore<K, V> getStore() {
        return this._store;
    }

    public final Retention<K> getRetention() {
        return this._retention;
    }

    @Override
    public final String getSource() {
        return this._source;
    }

    @Override
    public Position getPosition() {
        return this._retention.getPosition();
    }

    @Override
    public Position getPosition(Clock sinceClock) {
        Position pos;
        if (Clock.ZERO != sinceClock && (pos = this._retention.getPosition(sinceClock)) != null) {
            return pos;
        }
        return new SimplePosition(this._retention.getId(), this._retention.getOffset(), this.getStoreIndexStart(), sinceClock);
    }

    @Override
    public V get(K key) throws Exception {
        return key == null ? null : (V)this._store.get(key);
    }

    @Override
    public Position get(Position pos, Map<K, Event<V>> map) {
        ArrayList<Event<K>> list = new ArrayList<Event<K>>(1000);
        Position nextPos = this.get(pos, (List<Event<K>>)list);
        for (Event<K> evt : list) {
            K key = evt.getValue();
            if (key == null) continue;
            try {
                V value = this._store.get(key);
                map.put(key, new SimpleEvent<V>(value, evt.getClock()));
            }
            catch (Exception e) {
                _logger.warn((Object)e.getMessage());
            }
        }
        return nextPos;
    }

    @Override
    public Position get(Position pos, List<Event<K>> list) {
        Position nextPos;
        Position newPos;
        if (pos.getId() != this._retention.getId()) {
            if (pos.isIndexed()) {
                throw new InvalidPositionException("Bootstrap reconnection rejected", pos);
            }
            newPos = this.getPosition(pos.getClock());
            if (newPos == null) {
                newPos = new SimplePosition(this._retention.getId(), this._retention.getOffset(), this.getStoreIndexStart(), pos.getClock());
                _logger.warn((Object)("Reset position from " + pos + " to " + newPos));
            }
            pos = newPos;
        }
        if (pos.getOffset() < this._retention.getOrigin()) {
            newPos = new SimplePosition(this._retention.getId(), this._retention.getOffset(), this.getStoreIndexStart(), pos.getClock());
            _logger.warn((Object)("Reset position from " + pos + " to " + newPos));
            pos = newPos;
        }
        if ((nextPos = this._retention.get(pos, list)) == null && pos.isIndexed()) {
            int index = pos.getIndex();
            IndexedIterator<K> iter = this._store.keyIterator();
            try {
                iter.reset(index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                SimplePosition newPos2 = new SimplePosition(this._retention.getId(), pos.getOffset(), pos.getClock());
                _logger.warn((Object)("Reset position from " + pos + " to " + newPos2), (Throwable)e);
                return newPos2;
            }
            int cnt = 0;
            int lastIndex = index;
            while (iter.hasNext()) {
                lastIndex = iter.index();
                Object key = iter.next();
                index = iter.index();
                list.add(new SimpleEvent(key, pos.getClock()));
                if (++cnt < this._retention.getBatchSize()) continue;
                if (lastIndex != index) break;
                while (iter.hasNext() && iter.index() == index) {
                    key = iter.next();
                    list.add(new SimpleEvent(key, pos.getClock()));
                    ++cnt;
                }
                ++index;
                break;
            }
            if (cnt > 0) {
                _logger.info((Object)("Read[" + pos.getIndex() + "," + index + ") " + cnt));
            }
            if (iter.hasNext()) {
                return new SimplePosition(this._retention.getId(), pos.getOffset(), index, pos.getClock());
            }
            Clock newClock = this._retention.getClock(pos.getOffset());
            if (newClock == null) {
                newClock = pos.getClock();
            }
            return new SimplePosition(this._retention.getId(), pos.getOffset(), newClock);
        }
        return nextPos;
    }

    protected int getStoreIndexStart() {
        return this._store.keyIterator().index();
    }
}

