/*
 * Decompiled with CFR 0.152.
 */
package krati.retention;

import java.io.IOException;
import krati.retention.Retention;
import krati.retention.RetentionStoreWriter;
import krati.retention.SimpleEvent;
import krati.retention.clock.Clock;
import krati.retention.clock.WaterMarksClock;
import krati.store.DataStore;
import org.apache.log4j.Logger;

public class SimpleRetentionStoreWriter<K, V>
implements RetentionStoreWriter<K, V> {
    private static final Logger _logger = Logger.getLogger(SimpleRetentionStoreWriter.class);
    private final String _source;
    private final DataStore<K, V> _store;
    private final Retention<K> _retention;
    private final WaterMarksClock _waterMarksClock;
    private volatile long _hwmScn = 0L;

    public SimpleRetentionStoreWriter(String source, Retention<K> retention, DataStore<K, V> store, WaterMarksClock waterMarksClock) {
        this._source = source;
        this._retention = retention;
        this._store = store;
        this._waterMarksClock = waterMarksClock;
        this._hwmScn = waterMarksClock.getHWMScn(source);
        long lwmScn = waterMarksClock.getLWMScn(source);
        if (this._hwmScn < lwmScn) {
            lwmScn = this._hwmScn;
            waterMarksClock.updateWaterMarks(source, lwmScn, this._hwmScn);
        } else {
            waterMarksClock.setHWMark(source, this._hwmScn);
        }
        this.getLogger().info((Object)String.format("init %s lwmScn=%d hwmScn=%d", source, lwmScn, this._hwmScn));
    }

    protected Logger getLogger() {
        return _logger;
    }

    public final DataStore<K, V> getStore() {
        return this._store;
    }

    public final Retention<K> getRetention() {
        return this._retention;
    }

    @Override
    public final String getSource() {
        return this._source;
    }

    @Override
    public long getLWMark() {
        return this._waterMarksClock.getLWMScn(this._source);
    }

    @Override
    public long getHWMark() {
        return this._hwmScn;
    }

    @Override
    public synchronized void saveHWMark(long hwMark) {
        if (hwMark > this._hwmScn) {
            this._hwmScn = hwMark;
            this._waterMarksClock.setHWMark(this._source, this._hwmScn);
        }
    }

    @Override
    public synchronized void persist() throws IOException {
        this._store.persist();
        this._retention.flush();
        this._waterMarksClock.setHWMark(this._source, this._hwmScn);
        this._waterMarksClock.syncWaterMarks(this._source);
    }

    @Override
    public synchronized void sync() throws IOException {
        this._store.sync();
        this._retention.flush();
        this._waterMarksClock.setHWMark(this._source, this._hwmScn);
        this._waterMarksClock.syncWaterMarks(this._source);
    }

    @Override
    public synchronized boolean put(K key, V value, long scn) throws Exception {
        if (scn >= this._hwmScn) {
            this._store.put(key, value);
            Clock clock = scn == this._hwmScn ? this._waterMarksClock.current() : this._waterMarksClock.updateHWMark(this._source, scn);
            this._retention.put(new SimpleEvent<K>(key, clock));
            this._hwmScn = scn;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean delete(K key, long scn) throws Exception {
        if (scn >= this._hwmScn) {
            this._store.delete(key);
            Clock clock = scn == this._hwmScn ? this._waterMarksClock.current() : this._waterMarksClock.updateHWMark(this._source, scn);
            this._retention.put(new SimpleEvent<K>(key, clock));
            this._hwmScn = scn;
            return true;
        }
        return false;
    }
}

