/*
 * Decompiled with CFR 0.152.
 */
package krati.retention;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import krati.core.StoreConfig;
import krati.core.segment.SegmentFactory;
import krati.io.Serializer;
import krati.retention.Event;
import krati.retention.EventBatch;
import krati.retention.Position;
import krati.retention.Retention;
import krati.retention.RetentionFlushListener;
import krati.retention.SimpleEvent;
import krati.retention.SimplePosition;
import krati.retention.clock.Clock;
import krati.retention.policy.RetentionPolicy;
import krati.store.ObjectStore;
import krati.store.factory.ObjectStoreFactory;
import krati.util.IndexedIterator;
import org.apache.log4j.Logger;

class SimpleSnapshot<T>
implements Retention<T>,
RetentionFlushListener {
    private static final Logger _logger = Logger.getLogger(SimpleSnapshot.class);
    protected final int _id;
    protected final int _eventBatchSize;
    protected final StoreConfig _clockStoreConfig;
    protected final ObjectStore<T, Clock> _clockStore;
    protected volatile Clock _maxClock;

    public SimpleSnapshot(int id, File homeDir, int initialCapacity, int batchSize, int numSyncBatches, SegmentFactory storeSegmentFactory, int storeSegmentFileSizeMB, ObjectStoreFactory<T, Clock> clockStoreFactory, Serializer<T> eventValueSerializer, Serializer<Clock> eventClockSerializer) throws Exception {
        this._id = id;
        this._eventBatchSize = batchSize;
        this._clockStoreConfig = new StoreConfig(homeDir, initialCapacity);
        this._clockStoreConfig.setBatchSize(batchSize);
        this._clockStoreConfig.setNumSyncBatches(numSyncBatches);
        this._clockStoreConfig.setSegmentFactory(storeSegmentFactory);
        this._clockStoreConfig.setSegmentFileSizeMB(storeSegmentFileSizeMB);
        this._clockStore = clockStoreFactory.create(this._clockStoreConfig, eventValueSerializer, eventClockSerializer);
        this.init();
        _logger.info((Object)"started");
    }

    protected void init() {
    }

    protected Logger getLogger() {
        return _logger;
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public long getOrigin() {
        return 0L;
    }

    @Override
    public long getOffset() {
        return this._clockStore.capacity();
    }

    @Override
    public Clock getMinClock() {
        return Clock.ZERO;
    }

    @Override
    public Clock getMaxClock() {
        return this._maxClock;
    }

    @Override
    public Clock getClock(long offset) {
        return null;
    }

    @Override
    public int getBatchSize() {
        return this._eventBatchSize;
    }

    @Override
    public RetentionPolicy getRetentionPolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getPosition(Clock sinceClock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position get(Position pos, List<Event<T>> list) {
        if (pos == null || !pos.isIndexed() || pos.getId() != this._id) {
            return pos;
        }
        int index = pos.getIndex();
        IndexedIterator iter = this._clockStore.iterator();
        try {
            iter.reset(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new SimplePosition(this._id, pos.getOffset(), pos.getClock());
        }
        Clock posClock = pos.getClock();
        int cnt = 0;
        int lastIndex = index;
        while (iter.hasNext()) {
            lastIndex = iter.index();
            Map.Entry e = (Map.Entry)iter.next();
            Clock evtClock = (Clock)e.getValue();
            if (posClock.beforeEqual(evtClock)) {
                list.add(new SimpleEvent(e.getKey(), evtClock));
                ++cnt;
            }
            if (cnt < this._eventBatchSize) continue;
            index = iter.index();
            if (lastIndex != index) break;
            while (iter.hasNext() && iter.index() == index) {
                e = (Map.Entry)iter.next();
                evtClock = (Clock)e.getValue();
                if (!posClock.beforeEqual(evtClock)) continue;
                list.add(new SimpleEvent(e.getKey(), evtClock));
                ++cnt;
            }
            ++index;
            break;
        }
        if (cnt > 0) {
            this.getLogger().info((Object)("Read[" + pos.getIndex() + "," + index + ") " + cnt));
        }
        return iter.hasNext() ? new SimplePosition(this._id, pos.getOffset(), index, pos.getClock()) : new SimplePosition(this._id, pos.getOffset(), pos.getClock());
    }

    @Override
    public synchronized boolean put(Event<T> event) throws Exception {
        if (this._clockStore.put(event.getValue(), event.getClock())) {
            this._maxClock = event.getClock();
            return true;
        }
        return false;
    }

    @Override
    public void beforeFlush(EventBatch<?> batch) throws IOException {
        this._clockStore.persist();
    }

    @Override
    public void afterFlush(EventBatch<?> batch) throws IOException {
    }

    @Override
    public boolean isOpen() {
        return this._clockStore.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this._clockStore.isOpen()) {
            this._clockStore.open();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._clockStore.isOpen()) {
            this._clockStore.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this._clockStore.persist();
    }
}

