/*
 * Decompiled with CFR 0.152.
 */
package krati.retention.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import krati.retention.EventBatch;
import krati.retention.EventBatchCursor;
import krati.retention.policy.RetentionPolicy;

public class RetentionPolicyOnTime
implements RetentionPolicy {
    public static final long MIN_DURATION_MILLIS = 1000L;
    private long _duration;
    private TimeUnit _timeUnit;
    private long _timeMillis = 1000L;

    public RetentionPolicyOnTime() {
        this(4L, TimeUnit.HOURS);
    }

    public RetentionPolicyOnTime(int minutes) {
        this(Math.max(1, minutes), TimeUnit.MINUTES);
    }

    public RetentionPolicyOnTime(long duration, TimeUnit timeUnit) {
        this.setRetention(Math.max(1L, duration), timeUnit);
    }

    public final long getDuration() {
        return this._duration;
    }

    public final TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public final long getTimeMillis() {
        return this._timeMillis;
    }

    public void setRetention(long duration, TimeUnit timeUnit) {
        this._duration = Math.max(1L, duration);
        this._timeUnit = timeUnit;
        long millis = TimeUnit.MILLISECONDS == timeUnit ? this._duration : TimeUnit.MILLISECONDS.convert(this._duration, timeUnit);
        this._timeMillis = Math.max(millis, 1000L);
    }

    @Override
    public Collection<EventBatchCursor> apply(ConcurrentLinkedQueue<EventBatchCursor> queue) {
        ArrayList<EventBatchCursor> results = new ArrayList<EventBatchCursor>();
        while (queue.size() > 0) {
            EventBatchCursor c = queue.peek();
            if (c == null) continue;
            long diff = System.currentTimeMillis() - c.getHeader().getCompletionTime();
            if (diff <= this._timeMillis) break;
            c = queue.poll();
            results.add(c);
        }
        return results;
    }

    @Override
    public void applyCallbackOn(EventBatch<?> batch) {
    }

    @Override
    public boolean isCallback() {
        return false;
    }
}

