/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import krati.store.ArrayStore;
import krati.util.IndexedIterator;

public class ArrayStoreIndexIterator
implements IndexedIterator<Integer> {
    private final ArrayStore _store;
    private int _index;

    public ArrayStoreIndexIterator(ArrayStore store) {
        this._store = store;
        this._index = store.getIndexStart();
    }

    @Override
    public int index() {
        return this._index;
    }

    @Override
    public void reset(int indexStart) {
        if (this._store.hasIndex(indexStart)) {
            this._index = indexStart;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(indexStart);
    }

    @Override
    public boolean hasNext() {
        return this._store.hasIndex(this._index);
    }

    @Override
    public Integer next() {
        int ret = this._index++;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

