/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.util.AbstractMap;
import java.util.Map;
import krati.store.ArrayStore;
import krati.util.IndexedIterator;

public class ArrayStoreIterator
implements IndexedIterator<Map.Entry<Integer, byte[]>> {
    private final ArrayStore _store;
    private int _index;

    public ArrayStoreIterator(ArrayStore store) {
        this._store = store;
        this._index = store.getIndexStart();
    }

    @Override
    public int index() {
        return this._index;
    }

    @Override
    public void reset(int indexStart) {
        if (this._store.hasIndex(indexStart)) {
            this._index = indexStart;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(indexStart);
    }

    @Override
    public boolean hasNext() {
        return this._store.hasIndex(this._index);
    }

    @Override
    public Map.Entry<Integer, byte[]> next() {
        AbstractMap.SimpleEntry<Integer, byte[]> ret = new AbstractMap.SimpleEntry<Integer, byte[]>(this._index, this._store.get(this._index));
        ++this._index;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

