/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import krati.array.DynamicArray;
import krati.core.StoreConfig;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.segment.SegmentFactory;
import krati.store.AbstractDataArray;
import krati.store.ArrayStore;
import org.apache.log4j.Logger;

public final class DynamicDataArray
extends AbstractDataArray
implements DynamicArray,
ArrayStore {
    private static final Logger _log = Logger.getLogger(DynamicDataArray.class);

    public DynamicDataArray(StoreConfig config) throws Exception {
        super(config);
    }

    public DynamicDataArray(int initialLength, File homeDirectory, SegmentFactory segmentFactory) throws Exception {
        this(initialLength, 10000, 5, homeDirectory, segmentFactory, 256, 0.5);
    }

    public DynamicDataArray(int initialLength, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB) throws Exception {
        this(initialLength, 10000, 5, homeDirectory, segmentFactory, segmentFileSizeMB, 0.5);
    }

    public DynamicDataArray(int initialLength, int batchSize, int numSyncBatches, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor) throws Exception {
        super(initialLength, batchSize, numSyncBatches, homeDirectory, segmentFactory, segmentFileSizeMB, segmentCompactFactor);
        _log.info((Object)("init " + this.getStatus()));
    }

    @Override
    protected AddressArray createAddressArray(File homeDir, int length, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createDynamicAddressArray(homeDir, batchSize, numSyncBatches);
        addrArray.expandCapacity(length - 1);
        if (length != addrArray.length()) {
            _log.warn((Object)("array file length " + addrArray.length() + " is different from specified " + length));
        }
        return addrArray;
    }

    @Override
    public synchronized void expandCapacity(int index) throws Exception {
        this._addrArray.expandCapacity(index);
    }

    @Override
    public synchronized void set(int index, byte[] data, long scn) throws Exception {
        this._addrArray.expandCapacity(index);
        this._dataArray.set(index, data, scn);
    }

    @Override
    public synchronized void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        this._addrArray.expandCapacity(index);
        this._dataArray.set(index, data, offset, length, scn);
    }

    @Override
    public synchronized void delete(int index, long scn) throws Exception {
        if (this.hasIndex(index)) {
            this._dataArray.set(index, null, scn);
        }
    }

    @Override
    public final int getIndexStart() {
        return 0;
    }

    @Override
    public final int capacity() {
        return this.length();
    }

    @Override
    public final boolean isOpen() {
        return this._dataArray.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        this._dataArray.open();
    }

    @Override
    public synchronized void close() throws IOException {
        this._dataArray.close();
    }
}

