/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Map;
import krati.io.Serializer;
import krati.io.serializer.IntSerializer;
import krati.store.ArrayStore;
import krati.store.ArrayStoreIndexIterator;
import krati.store.ObjectArrayIterator;
import krati.store.ObjectStore;
import krati.store.StoreClosedException;
import krati.util.IndexedIterator;

public class SerializableObjectArray<V>
implements ObjectStore<Integer, V> {
    protected final ArrayStore _store;
    protected final Serializer<Integer> _keySerializer;
    protected final Serializer<V> _valSerializer;

    public SerializableObjectArray(ArrayStore store, Serializer<V> valueSerializer) {
        this(store, new IntSerializer(ByteOrder.BIG_ENDIAN), valueSerializer);
    }

    public SerializableObjectArray(ArrayStore store, Serializer<Integer> keySerializer, Serializer<V> valueSerializer) {
        this._store = store;
        this._keySerializer = keySerializer;
        this._valSerializer = valueSerializer;
    }

    protected long nextScn() {
        return System.currentTimeMillis();
    }

    public final ArrayStore getStore() {
        return this._store;
    }

    public final Serializer<Integer> getKeySerializer() {
        return this._keySerializer;
    }

    public final Serializer<V> getValueSerializer() {
        return this._valSerializer;
    }

    @Override
    public final int capacity() {
        return this._store.capacity();
    }

    @Override
    public V get(int index) {
        byte[] bytes = this._store.get(index);
        return bytes == null ? null : (V)this._valSerializer.deserialize(bytes);
    }

    @Override
    public V get(Integer key) {
        if (key == null) {
            return null;
        }
        int index = key;
        byte[] bytes = this._store.get(index);
        return bytes == null ? null : (V)this._valSerializer.deserialize(bytes);
    }

    @Override
    public byte[] getBytes(int index) {
        return this._store.get(index);
    }

    @Override
    public byte[] getBytes(Integer key) {
        if (key == null) {
            return null;
        }
        return this._store.get(key);
    }

    @Override
    public byte[] getBytes(byte[] keyBytes) {
        if (keyBytes == null) {
            return null;
        }
        int index = this._keySerializer.deserialize(keyBytes);
        return this._store.get(index);
    }

    public boolean set(int index, V value) throws Exception {
        if (value == null) {
            if (this._store.hasIndex(index)) {
                this._store.delete(index, this.nextScn());
                return true;
            }
            return false;
        }
        byte[] bytes = this._valSerializer.serialize(value);
        this._store.set(index, bytes, this.nextScn());
        return true;
    }

    @Override
    public boolean put(int index, V value) throws Exception {
        if (value == null) {
            if (this._store.hasIndex(index)) {
                this._store.delete(index, this.nextScn());
                return true;
            }
            return false;
        }
        byte[] bytes = this._valSerializer.serialize(value);
        this._store.set(index, bytes, this.nextScn());
        return true;
    }

    @Override
    public boolean put(Integer key, V value) throws Exception {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.set(key, value);
    }

    @Override
    public boolean delete(int index) throws Exception {
        if (this._store.hasIndex(index)) {
            this._store.delete(index, this.nextScn());
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(Integer key) throws Exception {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.delete((int)key);
    }

    @Override
    public IndexedIterator<Integer> keyIterator() {
        if (this._store.isOpen()) {
            return new ArrayStoreIndexIterator(this._store);
        }
        throw new StoreClosedException();
    }

    @Override
    public IndexedIterator<Map.Entry<Integer, V>> iterator() {
        if (this._store.isOpen()) {
            return new ObjectArrayIterator<V>(this._store, this._valSerializer);
        }
        return null;
    }

    @Override
    public void persist() throws IOException {
        this._store.persist();
    }

    @Override
    public void sync() throws IOException {
        this._store.sync();
    }

    @Override
    public boolean isOpen() {
        return this._store.isOpen();
    }

    @Override
    public void open() throws IOException {
        this._store.open();
    }

    @Override
    public void close() throws IOException {
        this._store.close();
    }

    @Override
    public void clear() throws IOException {
        this._store.clear();
    }
}

