/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import krati.array.DataArray;
import krati.core.StoreConfig;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.array.SimpleDataArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataSet;
import krati.store.DataSetHandler;
import krati.store.DefaultDataSetHandler;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.log4j.Logger;

public class StaticDataSet
implements DataSet<byte[]> {
    private static final Logger _log = Logger.getLogger(StaticDataSet.class);
    private final File _homeDir;
    private final StoreConfig _config;
    private final SimpleDataArray _dataArray;
    private final DataSetHandler _dataHandler;
    private final HashFunction<byte[]> _hashFunction;

    public StaticDataSet(StoreConfig config) throws Exception {
        config.validate();
        config.save();
        this._config = config;
        this._homeDir = this._config.getHomeDir();
        this._dataHandler = config.getDataHandler() == null ? new DefaultDataSetHandler() : (DataSetHandler)config.getDataHandler();
        AddressArray addressArray = this.createAddressArray(this._config.getHomeDir(), this._config.getInitialCapacity(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        if (addressArray.length() != this._config.getInitialCapacity()) {
            addressArray.close();
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + this._config.getInitialCapacity());
        }
        String segmentHome = this._homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(addressArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = this._config.getHashFunction();
    }

    public StaticDataSet(File homeDir, int capacity, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataSet(File homeDir, int capacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataSet(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataSet(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, hashFunction);
    }

    public StaticDataSet(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, HashFunction<byte[]> hashFunction) throws Exception {
        this._homeDir = homeDir;
        this._config = new StoreConfig(this._homeDir, capacity);
        this._config.setBatchSize(batchSize);
        this._config.setNumSyncBatches(numSyncBatches);
        this._config.setSegmentFactory(segmentFactory);
        this._config.setSegmentFileSizeMB(segmentFileSizeMB);
        this._config.setSegmentCompactFactor(segmentCompactFactor);
        this._config.setHashFunction(hashFunction);
        this._config.validate();
        this._config.save();
        this._dataHandler = new DefaultDataSetHandler();
        AddressArray addressArray = this.createAddressArray(this._config.getHomeDir(), this._config.getInitialCapacity(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        if (addressArray.length() != capacity) {
            addressArray.close();
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + capacity);
        }
        String segmentHome = this._homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(addressArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = this._config.getHashFunction();
    }

    protected AddressArray createAddressArray(File homeDir, int length, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createStaticAddressArray(homeDir, length, batchSize, numSyncBatches);
        return addrArray;
    }

    protected long hash(byte[] value) {
        return this._hashFunction.hash(value);
    }

    protected long nextScn() {
        return System.currentTimeMillis();
    }

    @Override
    public final int capacity() {
        return this._dataArray.length();
    }

    @Override
    public void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public boolean has(byte[] value) {
        byte[] existingData;
        if (value == null) {
            return false;
        }
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        return (existingData = this._dataArray.get(index)) == null ? false : this._dataHandler.find(value, existingData);
    }

    public final int countCollisions(byte[] value) {
        byte[] existingData;
        if (value == null) {
            return 0;
        }
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        return (existingData = this._dataArray.get(index)) == null ? 0 : this._dataHandler.countCollisions(value, existingData);
    }

    public final boolean hasWithoutCollisions(byte[] value) {
        return this.countCollisions(value) == 1;
    }

    @Override
    public synchronized boolean add(byte[] value) throws Exception {
        if (value == null) {
            return false;
        }
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        byte[] existingData = this._dataArray.get(index);
        try {
            if (existingData == null || existingData.length == 0) {
                this._dataArray.set(index, this._dataHandler.assemble(value), this.nextScn());
            } else if (!this._dataHandler.find(value, existingData)) {
                this._dataArray.set(index, this._dataHandler.assemble(value, existingData), this.nextScn());
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Value reset at index=" + index + " value=\"" + new String(value) + "\""), (Throwable)e);
            this._dataArray.set(index, this._dataHandler.assemble(value), this.nextScn());
        }
        return true;
    }

    @Override
    public synchronized boolean delete(byte[] value) throws Exception {
        if (value == null) {
            return false;
        }
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        try {
            byte[] existingData = this._dataArray.get(index);
            if (existingData != null) {
                int newLength = this._dataHandler.remove(value, existingData);
                if (newLength == 0) {
                    this._dataArray.set(index, null, this.nextScn());
                    return true;
                }
                if (newLength < existingData.length) {
                    this._dataArray.set(index, existingData, 0, newLength, this.nextScn());
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Failed to delete value=\"" + new String(value) + "\""), (Throwable)e);
            this._dataArray.set(index, null, this.nextScn());
        }
        return false;
    }

    @Override
    public synchronized void clear() throws IOException {
        this._dataArray.clear();
    }

    public final File getHomeDir() {
        return this._homeDir;
    }

    public final DataArray getDataArray() {
        return this._dataArray;
    }

    @Override
    public boolean isOpen() {
        return this._dataArray.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this._dataArray.isOpen()) {
            this._dataArray.open();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._dataArray.isOpen()) {
            this._dataArray.close();
        }
    }
}

