/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

public final class LinearHashing {
    private int _split;
    private int _level;
    private int _levelCapacity;
    private final int _unitCapacity;

    public LinearHashing(int unitCapacity) {
        if (unitCapacity < 1) {
            throw new IllegalArgumentException("Invalid argument " + unitCapacity);
        }
        this._unitCapacity = unitCapacity;
        this.reinit(unitCapacity);
    }

    public void reinit(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid argument " + capacity);
        }
        int unitCount = capacity / this._unitCapacity;
        if (unitCount <= 1) {
            this._level = 0;
            this._split = 0;
            this._levelCapacity = this._unitCapacity;
        } else {
            this._level = 0;
            for (int remainder = unitCount - 1 >> 1; remainder > 0; remainder >>= 1) {
                ++this._level;
            }
            this._split = (unitCount - (1 << this._level) - 1) * this._unitCapacity;
            this._levelCapacity = this._unitCapacity << this._level;
        }
    }

    public int getSplit() {
        return this._split;
    }

    public int getLevel() {
        return this._level;
    }

    public int getLevelCapacity() {
        return this._levelCapacity;
    }

    public int getUnitCapacity() {
        return this._unitCapacity;
    }
}

