/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.processor;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.apache.camel.bam.QueryUtils;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.rules.ProcessRules;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ActivityMonitorEngine
extends ServiceSupport
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityMonitorEngine.class);
    private JpaTemplate template;
    private TransactionTemplate transactionTemplate;
    private ProcessRules rules;
    private long windowMillis = 1000L;
    private Thread thread;
    private boolean useLocking;

    public ActivityMonitorEngine(JpaTemplate template, TransactionTemplate transactionTemplate, ProcessRules rules) {
        this.template = template;
        this.transactionTemplate = transactionTemplate;
        this.rules = rules;
    }

    public boolean isUseLocking() {
        return this.useLocking;
    }

    public void setUseLocking(boolean useLocking) {
        this.useLocking = useLocking;
    }

    @Override
    public void run() {
        LOG.debug("Starting to poll for timeout events");
        while (!this.isStopped()) {
            try {
                long now = System.currentTimeMillis();
                long nextPoll = now + this.windowMillis;
                final Date timeNow = new Date(now);
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        HashMap<String, Date> params = new HashMap<String, Date>(1);
                        params.put("timeNow", timeNow);
                        List list = CastUtils.cast((List)ActivityMonitorEngine.this.template.findByNamedParams("select x from " + QueryUtils.getTypeName(ActivityState.class) + " x where x.timeOverdue < :timeNow", params));
                        for (ActivityState activityState : list) {
                            ActivityMonitorEngine.this.fireExpiredEvent(activityState);
                        }
                    }
                });
                long timeToSleep = nextPoll - System.currentTimeMillis();
                if (timeToSleep <= 0L) continue;
                LOG.debug("Sleeping for {} millis", (Object)timeToSleep);
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException e) {
                    LOG.debug("Caught: " + e, (Throwable)e);
                }
            }
            catch (Exception e) {
                LOG.error("Caught: " + e, (Throwable)e);
            }
        }
    }

    protected void fireExpiredEvent(final ActivityState activityState) {
        LOG.debug("Trying to fire expiration of: {}", (Object)activityState);
        this.template.execute(new JpaCallback(){

            public Object doInJpa(EntityManager entityManager) throws PersistenceException {
                if (ActivityMonitorEngine.this.isUseLocking()) {
                    LOG.info("Attempting to lock: " + activityState);
                    entityManager.lock((Object)activityState, LockModeType.WRITE);
                    LOG.info("Grabbed lock: " + activityState);
                }
                try {
                    ActivityMonitorEngine.this.rules.processExpired(activityState);
                }
                catch (Exception e) {
                    LOG.error("Failed to process expiration of: " + activityState + ". Reason: " + e, (Throwable)e);
                }
                activityState.setTimeOverdue(null);
                return null;
            }
        });
    }

    protected void doStart() throws Exception {
        this.rules.start();
        this.thread = new Thread((Runnable)this, "ActivityMonitorEngine");
        this.thread.start();
    }

    protected void doStop() throws Exception {
        if (this.thread != null) {
            this.thread = null;
        }
        this.rules.stop();
    }
}

