/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.api;

import org.fusesource.hawtbuf.codec.Codec;
import org.fusesource.hawtbuf.codec.ObjectCodec;
import org.fusesource.hawtdb.api.Index;
import org.fusesource.hawtdb.api.IndexFactory;
import org.fusesource.hawtdb.api.Paged;
import org.fusesource.hawtdb.internal.index.HashIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashIndexFactory<Key, Value>
implements IndexFactory<Key, Value> {
    public static final String PROPERTY_PREFIX = HashIndex.class.getName() + ".";
    public static final int DEFAULT_BUCKET_CAPACITY = Integer.parseInt(System.getProperty(PROPERTY_PREFIX + "DEFAULT_BUCKET_CAPACITY", "1024"));
    public static final int DEFAULT_MAXIMUM_BUCKET_CAPACITY = Integer.parseInt(System.getProperty(PROPERTY_PREFIX + "DEFAULT_MAXIMUM_BUCKET_CAPACITY", "16384"));
    public static final int DEFAULT_MINIMUM_BUCKET_CAPACITY = Integer.parseInt(System.getProperty(PROPERTY_PREFIX + "DEFAULT_MINIMUM_BUCKET_CAPACITY", "16"));
    public static final int DEFAULT_LOAD_FACTOR = Integer.parseInt(System.getProperty(PROPERTY_PREFIX + "DEFAULT_LOAD_FACTOR", "75"));
    private Codec<Key> keyCodec = new ObjectCodec();
    private Codec<Value> valueCodec = new ObjectCodec();
    private int initialBucketCapacity = DEFAULT_BUCKET_CAPACITY;
    private int maximumBucketCapacity = DEFAULT_MAXIMUM_BUCKET_CAPACITY;
    private int minimumBucketCapacity = DEFAULT_MINIMUM_BUCKET_CAPACITY;
    private int loadFactor = DEFAULT_LOAD_FACTOR;
    private boolean deferredEncoding = true;

    @Override
    public Index<Key, Value> open(Paged paged, int indexNumber) {
        return this.createInstance(paged, indexNumber).open();
    }

    @Override
    public Index<Key, Value> open(Paged paged) {
        return this.createInstance(paged, 0).open();
    }

    @Override
    public Index<Key, Value> create(Paged paged) {
        return this.createInstance(paged, paged.alloc()).create();
    }

    @Override
    public Index<Key, Value> openOrCreate(Paged paged) {
        if (paged.allocator().isAllocated(0)) {
            return this.createInstance(paged, 0).open();
        }
        return this.createInstance(paged, paged.alloc()).create();
    }

    private HashIndex<Key, Value> createInstance(Paged paged, int page) {
        return new HashIndex(paged, page, this);
    }

    public Codec<Key> getKeyCodec() {
        return this.keyCodec;
    }

    public void setKeyCodec(Codec<Key> codec) {
        this.keyCodec = codec;
    }

    public Codec<Value> getValueCodec() {
        return this.valueCodec;
    }

    public void setValueCodec(Codec<Value> codec) {
        this.valueCodec = codec;
    }

    public int getMaximumBucketCapacity() {
        return this.maximumBucketCapacity;
    }

    public void setMaximumBucketCapacity(int value) {
        this.maximumBucketCapacity = value;
    }

    public int getMinimumBucketCapacity() {
        return this.minimumBucketCapacity;
    }

    public void setMinimumBucketCapacity(int value) {
        this.minimumBucketCapacity = value;
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
    }

    public int getBucketCapacity() {
        return this.initialBucketCapacity;
    }

    public void setBucketCapacity(int binCapacity) {
        this.initialBucketCapacity = binCapacity;
    }

    public void setFixedCapacity(int value) {
        this.maximumBucketCapacity = this.initialBucketCapacity = value;
        this.minimumBucketCapacity = this.initialBucketCapacity;
    }

    public boolean isDeferredEncoding() {
        return this.deferredEncoding;
    }

    public void setDeferredEncoding(boolean enable) {
        this.deferredEncoding = enable;
    }
}

