/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import org.fusesource.hawtdb.internal.page.Batch;
import org.fusesource.hawtdb.internal.page.HawtTxPageFile;
import org.fusesource.hawtdb.internal.page.SnapshotTracker;

final class Snapshot {
    private final HawtTxPageFile parent;
    private final SnapshotTracker tracker;
    private final Batch base;
    private final Batch latest;

    public Snapshot(HawtTxPageFile hawtPageFile, SnapshotTracker tracker, Batch base, Batch latest) {
        this.parent = hawtPageFile;
        this.tracker = tracker;
        this.base = base;
        this.latest = latest;
    }

    public Snapshot open() {
        ++this.tracker.snapshots;
        Batch cur = this.base;
        while (true) {
            ++cur.snapshots;
            if (cur == this.latest) break;
            cur = (Batch)cur.getNext();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HawtTxPageFile.TRANSACTION_MUTEX tRANSACTION_MUTEX = this.parent.TRANSACTION_MUTEX;
        synchronized (tRANSACTION_MUTEX) {
            --this.tracker.snapshots;
            Batch cur = this.base;
            while (true) {
                --cur.snapshots;
                if (cur == this.latest) break;
                cur = (Batch)cur.getNext();
            }
            if (this.tracker.snapshots == 0 && this.tracker.parentCommit != null) {
                this.tracker.parentCommit.snapshotTracker = null;
            }
        }
    }

    public SnapshotTracker getTracker() {
        return this.tracker;
    }
}

