/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdb.internal.page;

import java.util.Map;
import org.fusesource.hawtdb.api.PagedAccessor;
import org.fusesource.hawtdb.internal.page.Batch;
import org.fusesource.hawtdb.internal.page.Commit;
import org.fusesource.hawtdb.internal.page.DeferredUpdate;
import org.fusesource.hawtdb.internal.page.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SnapshotTracker {
    final Batch parentBatch;
    final Commit parentCommit;
    final long headRevision;
    protected volatile int snapshots;

    public SnapshotTracker(Batch parentBatch, Commit parentCommit) {
        this.parentBatch = parentBatch;
        this.parentCommit = parentCommit;
        Commit lastEntry = this.parentBatch.commits.getTail();
        this.headRevision = (lastEntry == null ? this.parentBatch.head : lastEntry.getHeadRevision()) + 1L;
    }

    public String toString() {
        return "{ references: " + this.snapshots + " }";
    }

    public long getHeadRevision() {
        return this.headRevision;
    }

    public int translatePage(int page) {
        if (this.parentCommit == null) {
            return page;
        }
        int rc = page;
        Batch batch = this.parentBatch;
        Commit commit = this.parentCommit;
        block0: while (!batch.isPerformed()) {
            Commit first = null;
            while (true) {
                if (first == null) {
                    first = commit;
                } else if (first == commit) break;
                Update update = commit.updates.get(rc);
                if (update != null) {
                    if (!update.shadowed()) break block0;
                    rc = update.shadow();
                    break block0;
                }
                commit = (Commit)commit.getPreviousCircular();
            }
            batch = (Batch)batch.getPrevious();
            if (batch == null) break;
            commit = batch.commits.getTail();
        }
        return rc;
    }

    public <T> T get(PagedAccessor<T> marshaller, int page) {
        if (this.parentCommit == null) {
            return null;
        }
        Batch batch = this.parentBatch;
        Commit commit = this.parentCommit;
        while (!batch.isPerformed()) {
            Commit tail = null;
            while (true) {
                DeferredUpdate du;
                if (tail == null) {
                    tail = commit;
                } else if (tail == commit) break;
                Update update = commit.updates.get(page);
                if (update != null && (du = update.deferredUpdate()) != null) {
                    return du.value();
                }
                commit = (Commit)commit.getPreviousCircular();
            }
            batch = (Batch)batch.getPrevious();
            if (batch == null) break;
            commit = batch.commits.getTail();
        }
        return null;
    }

    public long commitCheck(Map<Integer, Update> pageUpdates) {
        Commit commit;
        long rc = this.parentBatch.head;
        Batch batch = this.parentBatch;
        Commit commit2 = commit = this.parentCommit == null ? batch.commits.getHead() : (Commit)this.parentCommit.getNext();
        while (true) {
            if (commit != null) {
                rc = commit.commitCheck(pageUpdates);
                commit = (Commit)commit.getNext();
                continue;
            }
            if ((batch = (Batch)batch.getNext()) == null) break;
            commit = batch.commits.getHead();
        }
        return rc;
    }
}

