/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTrapConsumer
extends DefaultConsumer
implements CommandResponder {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTrapConsumer.class);
    private SnmpEndpoint endpoint;
    private Address listenGenericAddress;
    private Snmp snmp;
    private TransportMapping transport;

    public SnmpTrapConsumer(SnmpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting trap consumer on {}", (Object)this.endpoint.getAddress());
        }
        this.listenGenericAddress = GenericAddress.parse((String)this.endpoint.getAddress());
        if ("tcp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultTcpTransportMapping((TcpAddress)this.listenGenericAddress);
        } else if ("udp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultUdpTransportMapping((UdpAddress)this.listenGenericAddress);
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
        }
        this.snmp = new Snmp(this.transport);
        this.snmp.addCommandResponder((CommandResponder)this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting trap consumer on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
        this.transport.listen();
        if (LOG.isInfoEnabled()) {
            LOG.info("Started trap consumer on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
    }

    protected void doStop() throws Exception {
        if (this.transport != null && this.transport.isListening()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping trap consumer on {}", (Object)this.endpoint.getAddress());
            }
            this.transport.close();
            LOG.info("Stopped trap consumer on " + this.endpoint.getAddress());
        }
        super.doStop();
    }

    public void processPdu(CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (pdu != null) {
            this.processPDU(pdu);
        } else {
            LOG.debug("Received invalid trap PDU: " + pdu);
        }
    }

    public void processPDU(PDU pdu) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received trap event for {} : {}", (Object)this.endpoint.getAddress(), (Object)pdu);
        }
        Exchange exchange = this.endpoint.createExchange(pdu);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }
}

