/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.blobstore.functions.ReturnFalseOnContainerNotFound;
import org.jclouds.blobstore.functions.ReturnFalseOnKeyNotFound;
import org.jclouds.blobstore.functions.ReturnNullOnKeyNotFound;
import org.jclouds.blobstore.functions.ThrowContainerNotFoundOn404;
import org.jclouds.blobstore.functions.ThrowKeyNotFoundOn404;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.options.GetOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.binders.BindACLToXMLPayload;
import org.jclouds.s3.binders.BindAsHostPrefixIfConfigured;
import org.jclouds.s3.binders.BindBucketLoggingToXmlPayload;
import org.jclouds.s3.binders.BindNoBucketLoggingToXmlPayload;
import org.jclouds.s3.binders.BindPayerToXmlPayload;
import org.jclouds.s3.binders.BindS3ObjectMetadataToRequest;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.functions.BindRegionToXmlPayload;
import org.jclouds.s3.functions.ObjectKey;
import org.jclouds.s3.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.s3.functions.ParseObjectMetadataFromHeaders;
import org.jclouds.s3.functions.ReturnFalseIfBucketAlreadyOwnedByYouOrIllegalState;
import org.jclouds.s3.functions.ReturnTrueOn404OrNotFoundFalseOnIllegalState;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.predicates.validators.BucketNameValidator;
import org.jclouds.s3.xml.AccessControlListHandler;
import org.jclouds.s3.xml.BucketLoggingHandler;
import org.jclouds.s3.xml.CopyObjectHandler;
import org.jclouds.s3.xml.ListAllMyBucketsHandler;
import org.jclouds.s3.xml.ListBucketHandler;
import org.jclouds.s3.xml.LocationConstraintHandler;
import org.jclouds.s3.xml.PayerHandler;

@SkipEncoding(value={47})
@RequestFilters(value={RequestAuthorizeSignature.class})
@BlobScope(value=BlobScopes.CONTAINER)
public interface S3AsyncClient {
    public static final String VERSION = "2006-03-01";

    @Provides
    public S3Object newS3Object();

    @GET
    @Path(value="/{key}")
    @ExceptionParser(value=ReturnNullOnKeyNotFound.class)
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    public ListenableFuture<S3Object> getObject(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, GetOptions ... var3);

    @HEAD
    @Path(value="/{key}")
    @ExceptionParser(value=ReturnNullOnKeyNotFound.class)
    @ResponseParser(value=ParseObjectMetadataFromHeaders.class)
    public ListenableFuture<ObjectMetadata> headObject(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @HEAD
    @Path(value="/{key}")
    @ExceptionParser(value=ReturnFalseOnKeyNotFound.class)
    public ListenableFuture<Boolean> objectExists(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @DELETE
    @Path(value="/{key}")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteObject(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @PUT
    @Path(value="/{key}")
    @ResponseParser(value=ParseETagHeader.class)
    public ListenableFuture<String> putObject(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") @ParamParser(value=ObjectKey.class) @BinderParam(value=BindS3ObjectMetadataToRequest.class) S3Object var2, PutObjectOptions ... var3);

    @PUT
    @Path(value="/")
    @ExceptionParser(value=ReturnFalseIfBucketAlreadyOwnedByYouOrIllegalState.class)
    public ListenableFuture<Boolean> putBucketInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @BinderParam(value=BindRegionToXmlPayload.class) @Nullable String var1, @Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var2, PutBucketOptions ... var3);

    @DELETE
    @Path(value="/")
    @ExceptionParser(value=ReturnTrueOn404OrNotFoundFalseOnIllegalState.class)
    public ListenableFuture<Boolean> deleteBucketIfEmpty(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @HEAD
    @Path(value="/")
    @QueryParams(keys={"max-keys"}, values={"0"})
    @ExceptionParser(value=ReturnFalseOnContainerNotFound.class)
    public ListenableFuture<Boolean> bucketExists(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @GET
    @QueryParams(keys={"location"})
    @Path(value="/")
    @XMLResponseParser(value=LocationConstraintHandler.class)
    public ListenableFuture<String> getBucketLocation(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @GET
    @QueryParams(keys={"requestPayment"})
    @Path(value="/")
    @XMLResponseParser(value=PayerHandler.class)
    public ListenableFuture<Payer> getBucketPayer(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @PUT
    @QueryParams(keys={"requestPayment"})
    @Path(value="/")
    public ListenableFuture<Void> setBucketPayer(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindPayerToXmlPayload.class) Payer var2);

    @GET
    @Path(value="/")
    @XMLResponseParser(value=ListBucketHandler.class)
    public ListenableFuture<ListBucketResponse> listBucket(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, ListBucketOptions ... var2);

    @GET
    @XMLResponseParser(value=ListAllMyBucketsHandler.class)
    @Path(value="/")
    @VirtualHost
    public ListenableFuture<? extends Set<BucketMetadata>> listOwnedBuckets();

    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"x-amz-copy-source"}, values={"/{sourceBucket}/{sourceObject}"})
    @XMLResponseParser(value=CopyObjectHandler.class)
    public ListenableFuture<ObjectMetadata> copyObject(@PathParam(value="sourceBucket") String var1, @PathParam(value="sourceObject") String var2, @Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var3, @PathParam(value="destinationObject") String var4, CopyObjectOptions ... var5);

    @GET
    @QueryParams(keys={"acl"})
    @XMLResponseParser(value=AccessControlListHandler.class)
    @ExceptionParser(value=ThrowContainerNotFoundOn404.class)
    @Path(value="/")
    public ListenableFuture<AccessControlList> getBucketACL(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @PUT
    @Path(value="/")
    @QueryParams(keys={"acl"})
    public ListenableFuture<Boolean> putBucketACL(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindACLToXMLPayload.class) AccessControlList var2);

    @GET
    @QueryParams(keys={"acl"})
    @Path(value="/{key}")
    @XMLResponseParser(value=AccessControlListHandler.class)
    @ExceptionParser(value=ThrowKeyNotFoundOn404.class)
    public ListenableFuture<AccessControlList> getObjectACL(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @PUT
    @QueryParams(keys={"acl"})
    @Path(value="/{key}")
    public ListenableFuture<Boolean> putObjectACL(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @BinderParam(value=BindACLToXMLPayload.class) AccessControlList var3);

    @GET
    @QueryParams(keys={"logging"})
    @XMLResponseParser(value=BucketLoggingHandler.class)
    @ExceptionParser(value=ThrowContainerNotFoundOn404.class)
    @Path(value="/")
    public ListenableFuture<BucketLogging> getBucketLogging(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @PUT
    @Path(value="/")
    @QueryParams(keys={"logging"})
    public ListenableFuture<Void> enableBucketLogging(@Bucket @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindBucketLoggingToXmlPayload.class) BucketLogging var2);

    @PUT
    @Path(value="/")
    @QueryParams(keys={"logging"})
    @Produces(value={"text/xml"})
    public ListenableFuture<Void> disableBucketLogging(@Bucket @BinderParam(value=BindNoBucketLoggingToXmlPayload.class) @ParamValidators(value={BucketNameValidator.class}) String var1);
}

