/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import java.util.Properties;
import org.jclouds.PropertiesBuilder;

public class S3PropertiesBuilder
extends PropertiesBuilder {
    protected Properties defaultProperties() {
        Properties properties = super.defaultProperties();
        properties.setProperty("jclouds.api-version", "2006-03-01");
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        properties.setProperty("jclouds.s3.service-path", "/");
        properties.setProperty("jclouds.s3.virtual-host-buckets", "true");
        properties.setProperty("jclouds.relax-hostname", "true");
        properties.setProperty("jclouds.blobstore.directorysuffix", "_$folder$");
        return properties;
    }

    public S3PropertiesBuilder(Properties properties) {
        super(properties);
    }

    public S3PropertiesBuilder() {
    }

    protected S3PropertiesBuilder withMetaPrefix(String prefix) {
        this.properties.setProperty("jclouds.blobstore.metaprefix", prefix);
        return this;
    }

    protected void setMetaPrefix() {
        if (this.properties.getProperty("jclouds.blobstore.metaprefix") == null) {
            this.properties.setProperty("jclouds.blobstore.metaprefix", String.format("x-%s-meta-", this.properties.getProperty("jclouds.aws.header.tag")));
        }
    }

    public Properties build() {
        this.setMetaPrefix();
        return super.build();
    }
}

