/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.s3.domain.BucketMetadata;

@Singleton
public class BucketToResourceMetadata
implements Function<BucketMetadata, StorageMetadata> {
    private final Function<BucketMetadata, Location> locationOfBucket;

    @Inject
    BucketToResourceMetadata(Function<BucketMetadata, Location> locationOfBucket) {
        this.locationOfBucket = locationOfBucket;
    }

    public StorageMetadata apply(BucketMetadata from) {
        MutableStorageMetadataImpl to = new MutableStorageMetadataImpl();
        to.setName(from.getName());
        to.setType((Enum)StorageType.CONTAINER);
        to.setLocation((Location)this.locationOfBucket.apply((Object)from));
        return to;
    }
}

