/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.s3.options.ListBucketOptions;

@Singleton
public class ContainerToBucketListOptions
implements Function<ListContainerOptions, ListBucketOptions> {
    public ListBucketOptions apply(ListContainerOptions from) {
        Preconditions.checkNotNull((Object)from, (Object)"set options to instance NONE instead of passing null");
        ListBucketOptions httpOptions = new ListBucketOptions();
        if (!from.isRecursive()) {
            httpOptions.delimiter("/");
        }
        if (from.getDir() != null) {
            String path = from.getDir();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            httpOptions.withPrefix(path);
        }
        if (from.getMarker() != null) {
            httpOptions.afterMarker(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            httpOptions.maxResults(from.getMaxResults());
        }
        return httpOptions;
    }
}

