/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.config.AWSRestClientModule;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RequestSigner;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3ObjectModule;
import org.jclouds.s3.config.S3ParserModule;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.handlers.ParseS3ErrorFromXmlContent;
import org.jclouds.s3.handlers.S3RedirectionRetryHandler;

@ConfiguresRestClient
@RequiresHttp
public class S3RestClientModule<S extends S3Client, A extends S3AsyncClient>
extends AWSRestClientModule<S, A> {
    public static S3RestClientModule<S3Client, S3AsyncClient> create() {
        return new S3RestClientModule<S3Client, S3AsyncClient>(S3Client.class, S3AsyncClient.class);
    }

    public S3RestClientModule(Class<S> sync, Class<A> async) {
        super(sync, async);
    }

    @Provides
    @Bucket
    @Singleton
    protected Map<String, String> bucketToRegion() {
        return Maps.newConcurrentMap();
    }

    @Provides
    @Bucket
    @Singleton
    @Nullable
    protected String defaultRegionForBucket(@Nullable @Region String defaultRegion) {
        return defaultRegion;
    }

    protected void configure() {
        this.install((Module)new S3ObjectModule());
        this.install((Module)new S3ParserModule());
        this.bind(RequestAuthorizeSignature.class).in(Scopes.SINGLETON);
        super.configure();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseS3ErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseS3ErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseS3ErrorFromXmlContent.class);
    }

    @Provides
    @Singleton
    protected RequestSigner provideRequestSigner(RequestAuthorizeSignature in) {
        return in;
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(Redirection.class).to(S3RedirectionRetryHandler.class);
    }

    @Provides
    @TimeStamp
    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return (String)cache.get();
    }

    @Provides
    @TimeStamp
    @Singleton
    protected Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<String>(){

            public String get() {
                return dateService.rfc822DateFormat();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }
}

