/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseImmutableContentMetadata;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.ObjectMetadata;

public class BucketListObjectMetadata
implements Serializable,
ObjectMetadata {
    private static final long serialVersionUID = -4415449798024051115L;
    private final String key;
    private final String bucket;
    private final URI uri;
    private final Date lastModified;
    private final String eTag;
    private final CanonicalUser owner;
    private final ObjectMetadata.StorageClass storageClass;
    private final ContentMetadata contentMetadata;

    public BucketListObjectMetadata(String key, String bucket, URI uri, Date lastModified, String eTag, byte[] md5, long contentLength, CanonicalUser owner, ObjectMetadata.StorageClass storageClass) {
        this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"bucket");
        this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.owner = owner;
        this.contentMetadata = new BaseImmutableContentMetadata(null, Long.valueOf(contentLength), md5, null, null, null);
        this.storageClass = storageClass;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public CanonicalUser getOwner() {
        return this.owner;
    }

    @Override
    public ObjectMetadata.StorageClass getStorageClass() {
        return this.storageClass;
    }

    @Override
    public String getCacheControl() {
        return null;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(ObjectMetadata o) {
        return this == o ? 0 : this.getUri().compareTo(o.getUri());
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return ImmutableMap.of();
    }

    @Override
    public ContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketListObjectMetadata other = (BucketListObjectMetadata)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return String.format("[uri=%s, key=%s, bucket=%s, contentMetadata=%s, eTag=%s, lastModified=%s, owner=%s, storageClass=%s]", new Object[]{this.uri, this.key, this.bucket, this.contentMetadata, this.eTag, this.lastModified, this.owner, this.storageClass});
    }
}

