/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.s3.Bucket;

@Singleton
public class BindRegionToXmlPayload
extends BindToStringPayload {
    @Resource
    protected Logger logger = Logger.NULL;
    private final String defaultRegionForEndpoint;
    private final String defaultRegionForService;
    private final Set<String> regions;

    @Inject
    public BindRegionToXmlPayload(@Region @Nullable String defaultRegionForEndpoint, @Nullable @Bucket String defaultRegionForService, @Region Set<String> regions) {
        this.defaultRegionForEndpoint = defaultRegionForEndpoint;
        this.defaultRegionForService = defaultRegionForService;
        this.regions = (Set)Preconditions.checkNotNull(regions, (Object)"regions");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (this.defaultRegionForEndpoint == null) {
            return request;
        }
        input = input == null ? this.defaultRegionForEndpoint : input;
        Preconditions.checkArgument((boolean)(input instanceof String), (Object)"this binder is only valid for Region!");
        String constraint = (String)input;
        String value = null;
        if (this.defaultRegionForService == null && constraint == null || this.defaultRegionForService != null && this.defaultRegionForService.equals(constraint)) {
            return request;
        }
        if (this.regions.contains(constraint)) {
            value = constraint;
        } else {
            this.logger.warn("region %s not in %s ", new Object[]{constraint, this.regions});
            value = constraint;
        }
        String payload = String.format("<CreateBucketConfiguration><LocationConstraint>%s</LocationConstraint></CreateBucketConfiguration>", value);
        request = super.bindToRequest(request, (Object)payload);
        request.getPayload().getContentMetadata().setContentType("text/xml");
        return request;
    }
}

