/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.domain.MutableObjectMetadata;

public class ParseObjectMetadataFromHeaders
implements Function<HttpResponse, MutableObjectMetadata>,
InvocationContext<ParseObjectMetadataFromHeaders> {
    private final ParseSystemAndUserMetadataFromHeaders blobMetadataParser;
    private final BlobToObjectMetadata blobToObjectMetadata;
    private final String userMdPrefix;
    static final Pattern MD5_FROM_ETAG = Pattern.compile("^\"?([0-9a-f]+)\"?$");

    @Inject
    public ParseObjectMetadataFromHeaders(ParseSystemAndUserMetadataFromHeaders blobMetadataParser, BlobToObjectMetadata blobToObjectMetadata, @Named(value="jclouds.blobstore.metaprefix") String userMdPrefix) {
        this.blobMetadataParser = blobMetadataParser;
        this.blobToObjectMetadata = blobToObjectMetadata;
        this.userMdPrefix = userMdPrefix;
    }

    public MutableObjectMetadata apply(HttpResponse from) {
        Matcher md5Matcher;
        MutableBlobMetadata base = this.blobMetadataParser.apply(from);
        MutableObjectMetadata to = this.blobToObjectMetadata.apply((BlobMetadata)base);
        this.addETagTo(from, to);
        if (to.getContentMetadata().getContentMD5() == null && to.getETag() != null && (md5Matcher = MD5_FROM_ETAG.matcher(to.getETag())).find()) {
            byte[] md5 = CryptoStreams.hex((String)md5Matcher.group(1));
            if (from.getPayload() != null) {
                from.getPayload().getContentMetadata().setContentMD5(md5);
            }
            to.getContentMetadata().setContentMD5(md5);
        }
        to.getUserMetadata().remove("object-etag");
        to.setCacheControl(from.getFirstHeaderOrNull("Cache-Control"));
        return to;
    }

    @VisibleForTesting
    protected void addETagTo(HttpResponse from, MutableObjectMetadata metadata) {
        String eTagHeader;
        if (metadata.getETag() == null && (eTagHeader = from.getFirstHeaderOrNull(this.userMdPrefix + "object-eTag")) != null) {
            metadata.setETag(eTagHeader);
        }
    }

    public ParseObjectMetadataFromHeaders setContext(HttpRequest request) {
        this.blobMetadataParser.setContext(request);
        this.blobToObjectMetadata.setContext(request);
        return this;
    }

    public ParseObjectMetadataFromHeaders setKey(String key) {
        this.blobMetadataParser.setName(key);
        return this;
    }
}

