/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.Bucket;
import org.jclouds.util.SaxUtils;

public class LocationConstraintHandler
extends ParseSax.HandlerWithResult<String> {
    private final Map<String, String> bucketToRegion;
    private StringBuilder currentText = new StringBuilder();
    private String region;
    private String bucket;

    @Inject
    public LocationConstraintHandler(@Bucket Map<String, String> bucketToRegion) {
        this.bucketToRegion = bucketToRegion;
    }

    public String getResult() {
        return this.region;
    }

    public void endElement(String uri, String name, String qName) {
        this.region = LocationConstraintHandler.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        this.bucketToRegion.put(this.bucket, this.region);
    }

    public LocationConstraintHandler setContext(HttpRequest request) {
        super.setContext(request);
        this.setBucket(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(this.getRequest())).getArgs().get(0).toString());
        return this;
    }

    void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public static String fromValue(String v) {
        if (v == null || "".equals(v)) {
            return "us-standard";
        }
        return v;
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

