/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain;

import org.jclouds.cloudloadbalancers.domain.internal.BaseLoadBalancer;

public class LoadBalancerAttributes {
    protected String name;
    protected String protocol;
    protected Integer port;
    protected String algorithm;

    public LoadBalancerAttributes name(String name) {
        this.name = name;
        return this;
    }

    public LoadBalancerAttributes protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public LoadBalancerAttributes port(int port) {
        this.port = port;
        return this;
    }

    public LoadBalancerAttributes algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public static <T extends BaseLoadBalancer<?, T>> LoadBalancerAttributes fromLoadBalancer(T lb) {
        return Builder.name(lb.getName()).port(lb.getPort()).protocol(lb.getProtocol()).algorithm(lb.getAlgorithm());
    }

    public String toString() {
        return String.format("[algorithm=%s, name=%s, port=%s, protocol=%s]", this.algorithm, this.name, this.port, this.protocol);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerAttributes other = (LoadBalancerAttributes)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }

    public static class Builder {
        public static LoadBalancerAttributes name(String name) {
            return new LoadBalancerAttributes().name(name);
        }

        public static LoadBalancerAttributes protocol(String protocol) {
            return new LoadBalancerAttributes().protocol(protocol);
        }

        public static LoadBalancerAttributes port(int port) {
            return new LoadBalancerAttributes().port(port);
        }

        public static LoadBalancerAttributes algorithm(String algorithm) {
            return new LoadBalancerAttributes().algorithm(algorithm);
        }
    }
}

