/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain;

import com.google.common.base.Preconditions;
import org.jclouds.cloudloadbalancers.domain.internal.BaseNode;

public class Node
extends BaseNode<Node> {
    private int id;
    private Status status;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    Node() {
    }

    public Node(int id, String address, int port, BaseNode.Condition condition, Status status, Integer weight) {
        super(address, port, condition, weight);
        Preconditions.checkArgument((id != -1 ? 1 : 0) != 0, (Object)"id must be specified");
        this.id = id;
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
    }

    public int getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return String.format("[id=%s, address=%s, condition=%s,  port=%s,  weight=%s, status=%s]", new Object[]{this.id, this.address, this.condition, this.port, this.weight, this.status});
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.id == other.id;
    }

    public static enum Status {
        ONLINE,
        OFFLINE,
        DRAINING,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf((String)Preconditions.checkNotNull((Object)status, (Object)"status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder
    extends BaseNode.Builder<Node> {
        private int id = -1;
        private Status status;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Node build() {
            return new Node(this.id, this.address, this.port, this.condition, this.status, this.weight);
        }

        public Builder address(String address) {
            return (Builder)Builder.class.cast(super.address(address));
        }

        public Builder condition(BaseNode.Condition condition) {
            return (Builder)Builder.class.cast(super.condition(condition));
        }

        public Builder from(Node in) {
            return ((Builder)Builder.class.cast(super.from(in))).id(in.getId()).status(in.getStatus());
        }

        public Builder port(int port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder weight(Integer weight) {
            return (Builder)Builder.class.cast(super.weight(weight));
        }
    }
}

