/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain;

import com.google.common.base.Preconditions;

public class VirtualIP
implements Comparable<VirtualIP> {
    private int id;
    private String address;
    private Type type;
    private IPVersion ipVersion;

    public static Builder builder() {
        return new Builder();
    }

    VirtualIP() {
    }

    public VirtualIP(int id, String address, Type type, IPVersion ipVersion) {
        Preconditions.checkArgument((id != -1 ? 1 : 0) != 0, (Object)"id must be specified");
        this.id = id;
        this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.ipVersion = (IPVersion)((Object)Preconditions.checkNotNull((Object)((Object)ipVersion), (Object)"ipVersion"));
    }

    public int getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public Type getType() {
        return this.type;
    }

    public IPVersion getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public int compareTo(VirtualIP arg0) {
        return this.address.compareTo(arg0.address);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualIP other = (VirtualIP)obj;
        return this.id == other.id;
    }

    public String toString() {
        return String.format("[address=%s, id=%s, ipVersion=%s, type=%s]", new Object[]{this.address, this.id, this.ipVersion, this.type});
    }

    public static enum IPVersion {
        IPV4,
        IPV6,
        UNRECOGNIZED;


        public static IPVersion fromValue(String ipVersion) {
            try {
                return IPVersion.valueOf((String)Preconditions.checkNotNull((Object)ipVersion, (Object)"ipVersion"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        PUBLIC,
        SERVICENET,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private int id = -1;
        private String address;
        private Type type;
        private IPVersion ipVersion = IPVersion.IPV4;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder ipVersion(IPVersion ipVersion) {
            this.ipVersion = ipVersion;
            return this;
        }

        public VirtualIP build() {
            return new VirtualIP(this.id, this.address, this.type, this.ipVersion);
        }
    }
}

