/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import java.util.Date;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.cloudloadbalancers.functions.LB;
import org.jclouds.logging.Logger;

public class ConvertLB
implements Function<LB, LoadBalancer> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final String region;

    @Inject
    ConvertLB(@Assisted String region) {
        this.region = region.toUpperCase();
    }

    public LoadBalancer apply(LB lb) {
        try {
            LoadBalancer.Builder builder = ((LoadBalancer.Builder)LoadBalancer.builder().region(this.region).name(lb.getName()).port(lb.getPort()).protocol(lb.getProtocol()).algorithm(lb.getAlgorithm()).nodes((Iterable)lb.getNodes())).id(lb.id).status(lb.status).virtualIPs(lb.virtualIps);
            if (lb.cluster.size() == 1) {
                builder.clusterName((String)Iterables.get(lb.cluster.values(), (int)0));
            }
            if (lb.sessionPersistence.size() == 1) {
                builder.sessionPersistenceType((String)Iterables.get(lb.sessionPersistence.values(), (int)0));
            }
            if (lb.created.size() == 1) {
                builder.created((Date)Iterables.get(lb.created.values(), (int)0));
            }
            if (lb.updated.size() == 1) {
                builder.updated((Date)Iterables.get(lb.updated.values(), (int)0));
            }
            if (lb.connectionLogging.size() == 1) {
                builder.connectionLoggingEnabled((Boolean)Iterables.get(lb.connectionLogging.values(), (int)0));
            }
            return builder.build();
        }
        catch (NullPointerException e) {
            this.logger.warn((Throwable)e, "nullpointer found parsing %s", new Object[]{lb});
            throw e;
        }
    }

    public static interface Factory {
        public ConvertLB createForRegion(String var1);
    }
}

