/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.loadbalancer.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersClient;
import org.jclouds.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;

@Singleton
public class CloudLoadBalancersGetLoadBalancerMetadataStrategy
implements GetLoadBalancerMetadataStrategy {
    private final CloudLoadBalancersClient client;
    private final Function<LoadBalancer, LoadBalancerMetadata> converter;

    @Inject
    protected CloudLoadBalancersGetLoadBalancerMetadataStrategy(CloudLoadBalancersClient client, Function<LoadBalancer, LoadBalancerMetadata> converter) {
        this.client = (CloudLoadBalancersClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.converter = (Function)Preconditions.checkNotNull(converter, (Object)"converter");
    }

    public LoadBalancerMetadata getLoadBalancer(String id) {
        String[] parts = ((String)Preconditions.checkNotNull((Object)id, (Object)"id")).split("/");
        String region = parts[0];
        int lbId = Integer.parseInt(parts[1]);
        return (LoadBalancerMetadata)this.converter.apply((Object)this.client.getLoadBalancerClient(region).getLoadBalancer(lbId));
    }
}

