/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.mina2.Mina2Configuration;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.apache.camel.component.mina2.Mina2Helper;
import org.apache.camel.component.mina2.Mina2PayloadHelper;
import org.apache.camel.component.mina2.Mina2TextLineCodecFactory;
import org.apache.camel.component.mina2.Mina2TextLineDelimiter;
import org.apache.camel.component.mina2.Mina2UdpProtocolCodecFactory;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioDatagramAcceptor;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mina2Consumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(Mina2Consumer.class);
    private SocketAddress address;
    private IoAcceptor acceptor;
    private CamelLogger noReplyLogger;
    private Mina2Configuration configuration;
    private IoSessionConfig acceptorConfig;
    private boolean sync;

    public Mina2Consumer(Mina2Endpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.configuration = endpoint.getConfiguration();
        this.noReplyLogger = new CamelLogger(LOG, this.configuration.getNoReplyLogLevel());
        this.getEndpoint().setExchangePattern(ExchangePattern.InOut);
        String protocol = this.configuration.getProtocol();
        if (protocol.equals("tcp")) {
            this.createSocketEndpoint(protocol, this.configuration);
        } else if (this.configuration.isDatagramProtocol()) {
            this.createDatagramEndpoint(protocol, this.configuration);
        } else if (protocol.equals("vm")) {
            this.createVmEndpoint(protocol, this.configuration);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        ReceiveHandler handler = new ReceiveHandler();
        this.acceptor.setHandler((IoHandler)handler);
        this.acceptor.bind(this.address);
        LOG.info("Bound to server address: {} using acceptor: {}", (Object)this.address, (Object)this.acceptor);
    }

    protected void doStop() throws Exception {
        LOG.info("Unbinding from server address: {} using acceptor: {}", (Object)this.address, (Object)this.acceptor);
        this.acceptor.unbind(this.address);
        super.doStop();
    }

    protected void createVmEndpoint(String uri, Mina2Configuration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        List<IoFilter> filters = configuration.getFilters();
        this.address = new VmPipeAddress(configuration.getPort());
        this.acceptor = new VmPipeAcceptor();
        this.configureCodecFactory("Mina2Consumer", (IoService)this.acceptor, configuration);
        if (minaLogger) {
            this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.acceptor.getFilterChain());
    }

    protected void createSocketEndpoint(String uri, Mina2Configuration configuration) {
        LOG.debug("createSocketEndpoint");
        boolean minaLogger = configuration.isMinaLogger();
        long timeout = configuration.getTimeout();
        List<IoFilter> filters = configuration.getFilters();
        this.address = new InetSocketAddress(configuration.getHost(), configuration.getPort());
        this.acceptor = new NioSocketAcceptor((IoProcessor)new NioProcessor((Executor)this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MinaSocketAcceptor")));
        this.acceptorConfig = this.acceptor.getSessionConfig();
        this.configureCodecFactory("Mina2Consumer", (IoService)this.acceptor, configuration);
        ((NioSocketAcceptor)this.acceptor).setReuseAddress(true);
        this.acceptor.setCloseOnDeactivation(true);
        this.acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MinaThreadPool")));
        if (minaLogger) {
            this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.acceptor.getFilterChain());
    }

    protected void configureCodecFactory(String type, IoService service, Mina2Configuration configuration) {
        if (configuration.getCodec() != null) {
            this.addCodecFactory(service, configuration.getCodec());
        } else if (configuration.isAllowDefaultCodec()) {
            this.configureDefaultCodecFactory(type, service, configuration);
        }
    }

    protected void configureDefaultCodecFactory(String type, IoService service, Mina2Configuration configuration) {
        if (configuration.isTextline()) {
            Charset charset = this.getEncodingParameter(type, configuration);
            LineDelimiter delimiter = Mina2Consumer.getLineDelimiterParameter(configuration.getTextlineDelimiter());
            Mina2TextLineCodecFactory codecFactory = new Mina2TextLineCodecFactory(charset, delimiter);
            if (configuration.getEncoderMaxLineLength() > 0) {
                codecFactory.setEncoderMaxLineLength(configuration.getEncoderMaxLineLength());
            }
            if (configuration.getDecoderMaxLineLength() > 0) {
                codecFactory.setDecoderMaxLineLength(configuration.getDecoderMaxLineLength());
            }
            this.addCodecFactory(service, codecFactory);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Using TextLineCodecFactory: {} using encoding: {} line delimiter: {}({})", new Object[]{type, codecFactory, charset, configuration.getTextlineDelimiter(), delimiter});
                LOG.debug("Encoder maximum line length: {}. Decoder maximum line length: {}", (Object)codecFactory.getEncoderMaxLineLength(), (Object)codecFactory.getDecoderMaxLineLength());
            }
        } else {
            ObjectSerializationCodecFactory codecFactory = new ObjectSerializationCodecFactory();
            this.addCodecFactory(service, (ProtocolCodecFactory)codecFactory);
            LOG.debug("{}: Using ObjectSerializationCodecFactory: {}", (Object)type, (Object)codecFactory);
        }
    }

    protected void createDatagramEndpoint(String uri, Mina2Configuration configuration) {
        boolean minaLogger = configuration.isMinaLogger();
        long timeout = configuration.getTimeout();
        List<IoFilter> filters = configuration.getFilters();
        this.address = new InetSocketAddress(configuration.getHost(), configuration.getPort());
        this.acceptor = new NioDatagramAcceptor((Executor)this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MinaDatagramAcceptor"));
        this.acceptorConfig = this.acceptor.getSessionConfig();
        this.configureDataGramCodecFactory("MinaConsumer", (IoService)this.acceptor, configuration);
        this.acceptor.setCloseOnDeactivation(true);
        if (minaLogger) {
            this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.acceptor.getFilterChain());
    }

    protected void configureDataGramCodecFactory(String type, IoService service, Mina2Configuration configuration) {
        ProtocolCodecFactory codecFactory = configuration.getCodec();
        if (codecFactory == null) {
            Charset charset = this.getEncodingParameter(type, configuration);
            codecFactory = new Mina2UdpProtocolCodecFactory(this.getEndpoint().getCamelContext(), charset);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Using CodecFactory: {} using encoding: {}", new Object[]{type, codecFactory, charset});
            }
        }
        this.addCodecFactory(service, codecFactory);
    }

    private void addCodecFactory(IoService service, ProtocolCodecFactory codecFactory) {
        service.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(codecFactory));
    }

    private static LineDelimiter getLineDelimiterParameter(Mina2TextLineDelimiter delimiter) {
        if (delimiter == null) {
            return LineDelimiter.DEFAULT;
        }
        switch (delimiter) {
            case DEFAULT: {
                return LineDelimiter.DEFAULT;
            }
            case AUTO: {
                return LineDelimiter.AUTO;
            }
            case UNIX: {
                return LineDelimiter.UNIX;
            }
            case WINDOWS: {
                return LineDelimiter.WINDOWS;
            }
            case MAC: {
                return LineDelimiter.MAC;
            }
        }
        throw new IllegalArgumentException("Unknown textline delimiter: " + (Object)((Object)delimiter));
    }

    private Charset getEncodingParameter(String type, Mina2Configuration configuration) {
        String encoding = configuration.getEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            configuration.setEncoding(encoding);
            LOG.debug("{}: No encoding parameter using default charset: {}", (Object)type, (Object)encoding);
        }
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("The encoding: " + encoding + " is not supported");
        }
        return Charset.forName(encoding);
    }

    private void appendIoFiltersToChain(List<IoFilter> filters, DefaultIoFilterChainBuilder filterChain) {
        if (filters != null && filters.size() > 0) {
            for (IoFilter ioFilter : filters) {
                filterChain.addLast(ioFilter.getClass().getCanonicalName(), ioFilter);
            }
        }
    }

    public Mina2Endpoint getEndpoint() {
        return (Mina2Endpoint)super.getEndpoint();
    }

    public IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(IoAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    private final class ReceiveHandler
    extends IoHandlerAdapter {
        private ReceiveHandler() {
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (session != null) {
                LOG.warn("Closing session as an exception was thrown from MINA");
                session.close(true);
            }
            throw new CamelException(cause);
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            if (LOG.isDebugEnabled()) {
                Object in = object;
                if (in instanceof byte[]) {
                    in = Mina2Consumer.this.getEndpoint().getCamelContext().getTypeConverter().convertTo(String.class, in);
                }
                LOG.debug("Received body: {}", in);
            }
            Exchange exchange = Mina2Consumer.this.getEndpoint().createExchange(session, object);
            if (Mina2Consumer.this.getEndpoint().getConfiguration().getCharsetName() != null) {
                exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)Mina2Consumer.this.getEndpoint().getConfiguration().getCharsetName()));
            }
            try {
                Mina2Consumer.this.getProcessor().process(exchange);
            }
            catch (Throwable e) {
                Mina2Consumer.this.getExceptionHandler().handleException(e);
            }
            boolean disconnect = Mina2Consumer.this.getEndpoint().getConfiguration().isDisconnect();
            Object response = null;
            response = Mina2PayloadHelper.getOut(Mina2Consumer.this.getEndpoint(), exchange);
            boolean failed = exchange.isFailed();
            if (failed && !Mina2Consumer.this.getEndpoint().getConfiguration().isTransferExchange()) {
                response = exchange.getException() != null ? exchange.getException() : exchange.getOut().getBody();
            }
            if (response != null) {
                LOG.debug("Writing body: {}", response);
                Mina2Helper.writeBody(session, response, exchange);
            } else {
                LOG.debug("Writing no response");
                disconnect = Boolean.TRUE;
            }
            Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelMina2CloseSessionWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelMina2CloseSessionWhenComplete", Boolean.class);
            if (close != null) {
                disconnect = close;
            }
            if (disconnect) {
                LOG.debug("Closing session when complete at address: {}", (Object)Mina2Consumer.this.address);
                session.close(true);
            }
        }
    }
}

