/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.mina2.Mina2Configuration;
import org.apache.camel.component.mina2.Mina2Endpoint;
import org.apache.camel.component.mina2.Mina2Helper;
import org.apache.camel.component.mina2.Mina2PayloadHelper;
import org.apache.camel.component.mina2.Mina2TextLineCodecFactory;
import org.apache.camel.component.mina2.Mina2TextLineDelimiter;
import org.apache.camel.component.mina2.Mina2UdpProtocolCodecFactory;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioDatagramConnector;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mina2Producer
extends DefaultProducer
implements ServicePoolAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(Mina2Producer.class);
    private IoSession session;
    private CountDownLatch latch;
    private boolean lazySessionCreation;
    private long timeout;
    private SocketAddress address;
    private IoConnector connector;
    private boolean sync;
    private CamelLogger noReplyLogger;
    private Mina2Configuration configuration;
    private IoSessionConfig connectorConfig;

    public Mina2Producer(Mina2Endpoint endpoint) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.lazySessionCreation = this.configuration.isLazySessionCreation();
        this.timeout = this.configuration.getTimeout();
        this.sync = this.configuration.isSync();
        this.noReplyLogger = new CamelLogger(LOG, this.configuration.getNoReplyLogLevel());
        String protocol = this.configuration.getProtocol();
        if (protocol.equals("tcp")) {
            this.createSocketEndpoint(protocol);
        } else if (this.configuration.isDatagramProtocol()) {
            this.createDatagramEndpoint(protocol);
        } else if (protocol.equals("vm")) {
            this.createVmEndpoint(protocol);
        }
    }

    public Mina2Endpoint getEndpoint() {
        return (Mina2Endpoint)super.getEndpoint();
    }

    public boolean isSingleton() {
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        Object body;
        LOG.debug("Mina2Producer process");
        if (this.session == null && !this.lazySessionCreation) {
            throw new IllegalStateException("Not started yet!");
        }
        if (this.session == null || !this.session.isConnected()) {
            this.openConnection();
        }
        if (this.getEndpoint().getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOConverter.normalizeCharset((String)this.getEndpoint().getConfiguration().getCharsetName()));
        }
        if ((body = Mina2PayloadHelper.getIn(this.getEndpoint(), exchange)) == null) {
            this.noReplyLogger.log("No payload to send for exchange: " + exchange);
            return;
        }
        if (this.getEndpoint().getConfiguration().isTextline()) {
            body = this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, body);
        }
        if (this.sync) {
            this.latch = new CountDownLatch(1);
            ResponseHandler handler = (ResponseHandler)this.session.getHandler();
            handler.reset();
        }
        if (LOG.isDebugEnabled()) {
            Object out = body;
            if (body instanceof byte[]) {
                out = exchange.getContext().getTypeConverter().convertTo(String.class, body);
            }
            LOG.debug("Writing body : {}", out);
        }
        Mina2Helper.writeBody(this.session, body, exchange);
        if (this.sync) {
            LOG.debug("Waiting for response using timeout {} millis.", (Object)this.timeout);
            boolean done = this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (!done) {
                throw new ExchangeTimedOutException(exchange, this.timeout);
            }
            ResponseHandler handler = (ResponseHandler)this.session.getHandler();
            if (handler.getCause() != null) {
                throw new CamelExchangeException("Error occurred in ResponseHandler", exchange, handler.getCause());
            }
            if (!handler.isMessageReceived()) {
                throw new ExchangeTimedOutException(exchange, this.timeout);
            }
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                Mina2PayloadHelper.setOut(exchange, handler.getMessage());
            } else {
                Mina2PayloadHelper.setIn(exchange, handler.getMessage());
            }
        }
        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelMina2CloseSessionWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelMina2CloseSessionWhenComplete", Boolean.class);
        boolean disconnect = this.getEndpoint().getConfiguration().isDisconnect();
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing session when complete at address: {}", (Object)this.address);
            }
            this.session.close(true);
        }
    }

    public DefaultIoFilterChainBuilder getFilterChain() {
        return this.connector.getFilterChain();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.lazySessionCreation) {
            this.openConnection();
        }
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping connector: {} at address: {}", (Object)this.connector, (Object)this.address);
        }
        this.closeConnection();
        super.doStop();
    }

    private void closeConnection() {
        if (this.session != null) {
            CloseFuture closeFuture = this.session.close(true);
            closeFuture.awaitUninterruptibly();
        }
        this.connector.dispose(true);
    }

    private void openConnection() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: {} using connector: {} timeout: {} millis.", new Object[]{this.address, this.connector, this.timeout});
        }
        if (this.connectorConfig != null) {
            this.connector.getSessionConfig().setAll(this.connectorConfig);
        }
        this.connector.setHandler((IoHandler)new ResponseHandler(this.getEndpoint()));
        ConnectFuture future = this.connector.connect(this.address);
        future.awaitUninterruptibly();
        this.session = future.getSession();
    }

    protected void createVmEndpoint(String uri) {
        boolean minaLogger = this.configuration.isMinaLogger();
        List<IoFilter> filters = this.configuration.getFilters();
        this.address = new VmPipeAddress(this.configuration.getPort());
        this.connector = new VmPipeConnector();
        if (minaLogger) {
            this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.connector.getFilterChain());
        this.configureCodecFactory("Mina2Producer", (IoService)this.connector);
        if (this.sync) {
            this.getEndpoint().setExchangePattern(ExchangePattern.InOut);
        } else {
            this.getEndpoint().setExchangePattern(ExchangePattern.InOnly);
        }
    }

    protected void createSocketEndpoint(String uri) {
        LOG.debug("createSocketEndpoint");
        boolean minaLogger = this.configuration.isMinaLogger();
        long timeout = this.configuration.getTimeout();
        List<IoFilter> filters = this.configuration.getFilters();
        this.address = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        this.connector = new NioSocketConnector((IoProcessor)new NioProcessor((Executor)this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MinaSocketConnector")));
        this.connectorConfig = this.connector.getSessionConfig();
        this.connector.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MinaThreadPool")));
        if (minaLogger) {
            this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.connector.getFilterChain());
        this.configureCodecFactory("Mina2Producer", (IoService)this.connector);
        this.connector.setConnectTimeoutMillis(timeout);
        if (this.sync) {
            this.getEndpoint().setExchangePattern(ExchangePattern.InOut);
        } else {
            this.getEndpoint().setExchangePattern(ExchangePattern.InOnly);
        }
    }

    protected void configureCodecFactory(String type, IoService service) {
        LOG.debug("configureCodecFactory");
        if (this.configuration.getCodec() != null) {
            this.addCodecFactory(service, this.configuration.getCodec());
        } else if (this.configuration.isAllowDefaultCodec()) {
            this.configureDefaultCodecFactory(type, service);
        }
    }

    protected void configureDefaultCodecFactory(String type, IoService service) {
        LOG.debug("configureDefaultCodecFactory");
        if (this.configuration.isTextline()) {
            Charset charset = this.getEncodingParameter(type, this.configuration);
            LineDelimiter delimiter = Mina2Producer.getLineDelimiterParameter(this.configuration.getTextlineDelimiter());
            Mina2TextLineCodecFactory codecFactory = new Mina2TextLineCodecFactory(charset, delimiter);
            if (this.configuration.getEncoderMaxLineLength() > 0) {
                codecFactory.setEncoderMaxLineLength(this.configuration.getEncoderMaxLineLength());
            }
            if (this.configuration.getDecoderMaxLineLength() > 0) {
                codecFactory.setDecoderMaxLineLength(this.configuration.getDecoderMaxLineLength());
            }
            this.addCodecFactory(service, codecFactory);
            LOG.debug("{}: Using TextLineCodecFactory: {} using encoding: {} line delimiter: {}({})", new Object[]{type, codecFactory, charset, this.configuration.getTextlineDelimiter(), delimiter});
            LOG.debug("Encoder maximum line length: {}. Decoder maximum line length: {}", (Object)codecFactory.getEncoderMaxLineLength(), (Object)codecFactory.getDecoderMaxLineLength());
        } else {
            ObjectSerializationCodecFactory codecFactory = new ObjectSerializationCodecFactory();
            this.addCodecFactory(service, (ProtocolCodecFactory)codecFactory);
            LOG.debug("{}: Using ObjectSerializationCodecFactory: {}", (Object)type, (Object)codecFactory);
        }
        LOG.debug("configureDefaultCodecFactory exit");
    }

    protected void createDatagramEndpoint(String uri) {
        boolean minaLogger = this.configuration.isMinaLogger();
        boolean transferExchange = this.configuration.isTransferExchange();
        List<IoFilter> filters = this.configuration.getFilters();
        if (transferExchange) {
            throw new IllegalArgumentException("transferExchange=true is not supported for datagram protocol");
        }
        this.address = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        this.connector = new NioDatagramConnector((IoProcessor)new NioProcessor((Executor)this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MinaDatagramConnector")));
        this.connectorConfig = this.connector.getSessionConfig();
        this.connector.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "MinaThreadPool")));
        if (minaLogger) {
            this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.connector.getFilterChain());
        this.configureDataGramCodecFactory("Mina2Producer", (IoService)this.connector, this.configuration);
        this.connector.setConnectTimeoutMillis(this.timeout);
        if (this.sync) {
            this.getEndpoint().setExchangePattern(ExchangePattern.InOut);
        } else {
            this.getEndpoint().setExchangePattern(ExchangePattern.InOnly);
        }
    }

    protected void configureDataGramCodecFactory(String type, IoService service, Mina2Configuration configuration) {
        ProtocolCodecFactory codecFactory = configuration.getCodec();
        if (codecFactory == null) {
            Charset charset = this.getEncodingParameter(type, configuration);
            codecFactory = new Mina2UdpProtocolCodecFactory(this.getEndpoint().getCamelContext(), charset);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Using CodecFactory: {} using encoding: {}", new Object[]{type, codecFactory, charset});
            }
        }
        this.addCodecFactory(service, codecFactory);
    }

    private void addCodecFactory(IoService service, ProtocolCodecFactory codecFactory) {
        LOG.debug("addCodecFactory name: {}", (Object)codecFactory.getClass().getName());
        service.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(codecFactory));
    }

    private static LineDelimiter getLineDelimiterParameter(Mina2TextLineDelimiter delimiter) {
        if (delimiter == null) {
            return LineDelimiter.DEFAULT;
        }
        switch (delimiter) {
            case DEFAULT: {
                return LineDelimiter.DEFAULT;
            }
            case AUTO: {
                return LineDelimiter.AUTO;
            }
            case UNIX: {
                return LineDelimiter.UNIX;
            }
            case WINDOWS: {
                return LineDelimiter.WINDOWS;
            }
            case MAC: {
                return LineDelimiter.MAC;
            }
        }
        throw new IllegalArgumentException("Unknown textline delimiter: " + (Object)((Object)delimiter));
    }

    private Charset getEncodingParameter(String type, Mina2Configuration configuration) {
        String encoding = configuration.getEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            configuration.setEncoding(encoding);
            LOG.debug("{}: No encoding parameter using default charset: {}", (Object)type, (Object)encoding);
        }
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("The encoding: " + encoding + " is not supported");
        }
        return Charset.forName(encoding);
    }

    private void appendIoFiltersToChain(List<IoFilter> filters, DefaultIoFilterChainBuilder filterChain) {
        if (filters != null && filters.size() > 0) {
            for (IoFilter ioFilter : filters) {
                filterChain.addLast(ioFilter.getClass().getCanonicalName(), ioFilter);
            }
        }
    }

    private final class ResponseHandler
    extends IoHandlerAdapter {
        private Mina2Endpoint endpoint;
        private Object message;
        private Throwable cause;
        private boolean messageReceived;

        private ResponseHandler(Mina2Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void reset() {
            this.message = null;
            this.cause = null;
            this.messageReceived = false;
        }

        public void messageReceived(IoSession ioSession, Object message) throws Exception {
            LOG.debug("Message received: {}", message);
            this.message = message;
            this.messageReceived = true;
            this.cause = null;
            this.countDown();
        }

        protected void countDown() {
            CountDownLatch downLatch = Mina2Producer.this.latch;
            if (downLatch != null) {
                downLatch.countDown();
            }
        }

        public void sessionClosed(IoSession session) throws Exception {
            if (Mina2Producer.this.sync && !this.messageReceived) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session closed but no message received from address: {}", (Object)Mina2Producer.this.address);
                }
                this.countDown();
            }
        }

        public void exceptionCaught(IoSession ioSession, Throwable cause) {
            LOG.error("Exception on receiving message from address: " + Mina2Producer.this.address + " using connector: " + Mina2Producer.this.connector, cause);
            this.message = null;
            this.messageReceived = false;
            this.cause = cause;
            if (ioSession != null) {
                ioSession.close(true);
            }
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object getMessage() {
            return this.message;
        }

        public boolean isMessageReceived() {
            return this.messageReceived;
        }
    }
}

