/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.JMSException;
import javax.jms.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJmsMarshaler {
    public static final String DONE_JMS_PROPERTY = "JBIDone";
    public static final String FAULT_JMS_PROPERTY = "JBIFault";
    public static final String ERROR_JMS_PROPERTY = "JBIError";
    public static final String CONTENT_TYPE_PROPERTY = "SOAPJMS_contentType";
    private boolean copyProperties = true;
    private boolean needJavaIdentifiers;
    private List<String> propertyBlackList = null;

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    protected void copyPropertiesFromJMS(Message message, NormalizedMessage inMessage) throws JMSException {
        Enumeration names = message.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = message.getObjectProperty(name);
            if (this.isBlackListed(name)) continue;
            inMessage.setProperty(name, value);
        }
    }

    protected void copyPropertiesFromNM(NormalizedMessage outMessage, Message message) throws JMSException {
        Set names = outMessage.getPropertyNames();
        for (String name : names) {
            Object value = outMessage.getProperty(name);
            if (this.isBlackListed(name) || !this.shouldIncludeHeader(name, value)) continue;
            message.setObjectProperty(name, value);
        }
    }

    protected boolean shouldIncludeHeader(String name, Object value) {
        return !(!(value instanceof Boolean) && !(value instanceof Byte) && !(value instanceof Short) && !(value instanceof Integer) && !(value instanceof Long) && !(value instanceof Float) && !(value instanceof Double) && !(value instanceof String) || this.isNeedJavaIdentifiers() && !AbstractJmsMarshaler.isJavaIdentifier(name));
    }

    public boolean isBlackListed(String name) {
        return this.propertyBlackList != null && this.propertyBlackList.contains(name);
    }

    private static boolean isJavaIdentifier(String s) {
        int n = s.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public List<String> getPropertyBlackList() {
        return this.propertyBlackList;
    }

    public void setPropertyBlackList(List<String> propertyBlackList) {
        this.propertyBlackList = propertyBlackList;
    }

    public boolean isNeedJavaIdentifiers() {
        return this.needJavaIdentifiers;
    }

    public void setNeedJavaIdentifiers(boolean needJavaIdentifiers) {
        this.needJavaIdentifiers = needJavaIdentifiers;
    }
}

