/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.smpp;

import java.io.IOException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.smpp.SmppEndpointType;
import org.apache.servicemix.smpp.marshaler.DefaultSmppMarshaler;
import org.apache.servicemix.smpp.marshaler.SmppMarshalerSupport;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.MessageRequest;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppConsumerEndpoint
extends ConsumerEndpoint
implements SmppEndpointType {
    private final Logger logger = LoggerFactory.getLogger(SmppConsumerEndpoint.class);
    private static final int SMPP_DEFAULT_PORT = 2775;
    private static final String DEFAULT_SYSTEM_TYPE = "cp";
    private SMPPSession session;
    private String host;
    private int port;
    private String systemId;
    private String password;
    private String systemType = "cp";
    private int enquireLinkTimer = 50000;
    private int transactionTimer = 100000;
    private SmppMarshalerSupport marshaler;

    public synchronized void start() throws Exception {
        super.start();
        this.connect();
    }

    public synchronized void stop() throws Exception {
        this.disconnect();
        super.stop();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.port <= 0) {
            this.logger.warn("Invalid SMPP port specified. Use the default one : {}", (Object)2775);
            this.port = 2775;
        }
        if (this.host == null || this.host.trim().length() <= 0) {
            throw new IllegalArgumentException("The SMPP host name is mandatory.");
        }
        if (this.systemId == null || this.systemId.trim().length() <= 0) {
            throw new IllegalArgumentException("The SMPP system ID is mandatory.");
        }
        if (this.enquireLinkTimer <= 0) {
            throw new IllegalArgumentException("The enquireLinkTimer value must be greater than 0.");
        }
        if (this.transactionTimer <= 0) {
            throw new IllegalArgumentException("The transactionTimer value must be greater than 0.");
        }
        if (this.marshaler == null) {
            this.marshaler = new DefaultSmppMarshaler();
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        throw new MessagingException("Unsupported exchange received...");
    }

    private void connect() {
        this.session = new SMPPSession();
        this.session.setEnquireLinkTimer(this.enquireLinkTimer);
        this.session.setTransactionTimer((long)this.transactionTimer);
        this.session.setMessageReceiverListener(new MessageReceiverListener(){

            public void onAcceptAlertNotification(AlertNotification alertNotification) {
            }

            public void onAcceptDeliverSm(DeliverSm deliverSm) {
                try {
                    InOnly exchange = SmppConsumerEndpoint.this.getExchangeFactory().createInOnlyExchange();
                    NormalizedMessage in = exchange.createMessage();
                    exchange.setInMessage(in);
                    SmppConsumerEndpoint.this.marshaler.toNMS(in, (MessageRequest)deliverSm);
                    SmppConsumerEndpoint.this.send((MessageExchange)exchange);
                }
                catch (MessagingException messagingException) {
                    SmppConsumerEndpoint.this.logger.error("Unable to send the received SMS to the NMR", (Throwable)messagingException);
                }
            }
        });
        try {
            this.session.connectAndBind(this.host, this.port, new BindParameter(BindType.BIND_RX, this.systemId, this.password, this.systemType, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
        }
        catch (IOException ioException) {
            this.logger.error("Error connecting to the SMPP server", (Throwable)ioException);
            return;
        }
    }

    private void disconnect() {
        if (this.session == null) {
            return;
        }
        this.session.unbindAndClose();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public SmppMarshalerSupport getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(SmppMarshalerSupport marshaler) {
        this.marshaler = marshaler;
    }

    public int getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    public void setEnquireLinkTimer(int enquireLinkTimer) {
        this.enquireLinkTimer = enquireLinkTimer;
    }

    public int getTransactionTimer() {
        return this.transactionTimer;
    }

    public void setTransactionTimer(int transactionTimer) {
        this.transactionTimer = transactionTimer;
    }
}

