/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.StringSource;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.MessageHelper;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestletBinding
implements RestletBinding,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestletBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    @Override
    public void populateExchangeFromRestletRequest(Request request, Response response, Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        inMessage.setHeader("CamelRestletRequest", (Object)request);
        inMessage.setHeader("CamelRestletResponse", (Object)response);
        for (Map.Entry entry : request.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            inMessage.setHeader((String)entry.getKey(), entry.getValue());
            LOG.debug("Populate exchange from Restlet request header: {} value: {}", entry.getKey(), entry.getValue());
        }
        String query = request.getResourceRef().getQuery();
        if (query != null) {
            inMessage.setHeader("CamelHttpQuery", (Object)query);
        }
        inMessage.setHeader("CamelHttpUri", (Object)request.getResourceRef().getIdentifier(true));
        inMessage.setHeader("CamelHttpMethod", (Object)request.getMethod().toString());
        if (!request.isEntityAvailable()) {
            return;
        }
        if (request.getEntity().getMediaType() != null && request.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM)) {
            Form form = new Form(request.getEntity());
            for (Map.Entry entry : form.getValuesMap().entrySet()) {
                if (entry.getValue() == null) {
                    inMessage.setBody(entry.getKey());
                    LOG.debug("Populate exchange from Restlet request body: {}", entry.getValue());
                    continue;
                }
                if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                inMessage.setHeader((String)entry.getKey(), entry.getValue());
                LOG.debug("Populate exchange from Restlet request user header: {} value: {}", entry.getKey(), entry.getValue());
            }
        } else {
            inMessage.setBody((Object)request.getEntity().getStream());
        }
    }

    @Override
    public void populateRestletRequestFromExchange(Request request, Exchange exchange) {
        request.setReferrerRef("camel-restlet");
        String body = (String)exchange.getIn().getBody(String.class);
        Form form = new Form();
        form.add(body, null);
        MediaType mediaType = (MediaType)exchange.getIn().getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_WWW_FORM;
        }
        LOG.debug("Populate Restlet request from exchange body: {} using media type {}", (Object)body, (Object)mediaType);
        String login = (String)exchange.getIn().getHeader("CamelRestletLogin", String.class);
        String password = (String)exchange.getIn().getHeader("CamelRestletPassword", String.class);
        if (login != null && password != null) {
            ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, login, password);
            request.setChallengeResponse(authentication);
            LOG.debug("Basic HTTP Authentication has been applied");
        }
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
                if (((String)entry.getKey()).startsWith("org.restlet.")) {
                    request.getAttributes().put(entry.getKey(), entry.getValue());
                } else {
                    form.add((String)entry.getKey(), entry.getValue().toString());
                }
            } else {
                request.getAttributes().put(entry.getKey(), entry.getValue());
            }
            LOG.debug("Populate Restlet request from exchange header: {} value: {}", entry.getKey(), entry.getValue());
        }
        LOG.debug("Using Content Type: {} for POST data: {}", (Object)mediaType, (Object)body);
        if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
            request.setEntity(form.getWebRepresentation());
        } else {
            request.setEntity(body, mediaType);
        }
        MediaType acceptedMediaType = (MediaType)exchange.getIn().getHeader("CamelAcceptContentType", MediaType.class);
        if (acceptedMediaType != null) {
            request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)acceptedMediaType));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateRestletResponseFromExchange(Exchange exchange, Response response) throws Exception {
        Object body;
        Integer responseCode;
        Message out;
        block20: {
            if (exchange.isFailed()) {
                response.setStatus(Status.valueOf((int)500));
                if (exchange.hasOut() && exchange.getOut().isFault()) {
                    out = exchange.getOut();
                    break block20;
                } else {
                    Exception t = exchange.getException();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    response.setEntity(sw.toString(), MediaType.TEXT_PLAIN);
                    return;
                }
            }
            out = exchange.getOut();
        }
        MediaType mediaType = (MediaType)out.getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            Object body2 = out.getBody();
            mediaType = MediaType.TEXT_PLAIN;
            if (body2 instanceof String) {
                mediaType = MediaType.TEXT_PLAIN;
            } else if (body2 instanceof StringSource || body2 instanceof DOMSource) {
                mediaType = MediaType.TEXT_XML;
            }
        }
        if ((responseCode = (Integer)out.getHeader("CamelHttpResponseCode", Integer.class)) != null) {
            response.setStatus(Status.valueOf((int)responseCode));
        }
        if ((body = out.getBody()) instanceof WrappedFile) {
            GenericFile gf = (GenericFile)body;
            body = gf.getBody();
        }
        if (body == null) {
            response.setEntity("", MediaType.TEXT_PLAIN);
        } else if (body instanceof Response) {
            LOG.debug("Using existing Restlet Response from exchange body: {}", body);
        } else if (body instanceof InputStream) {
            response.setEntity((Representation)new InputRepresentation((InputStream)out.getBody(InputStream.class), mediaType));
        } else if (body instanceof File) {
            response.setEntity((Representation)new FileRepresentation((File)out.getBody(File.class), mediaType));
        } else {
            String text = (String)out.getBody(String.class);
            response.setEntity(text, mediaType);
        }
        LOG.debug("Populate Restlet response from exchange body: {}", body);
        if (exchange.getProperty("CamelCharsetName") != null) {
            CharacterSet cs = CharacterSet.valueOf((String)((String)exchange.getProperty("CamelCharsetName", String.class)));
            response.getEntity().setCharacterSet(cs);
        }
        Iterator i$ = out.getHeaders().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            this.setResponseHeader(exchange, (org.restlet.Message)response, (String)entry.getKey(), entry.getValue());
            LOG.debug("Populate Restlet HTTP header in response from exchange header: {} value: {}", entry.getKey(), entry.getValue());
        }
        return;
    }

    @Override
    public void populateExchangeFromRestletResponse(Exchange exchange, Response response) throws Exception {
        for (Map.Entry entry : response.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            exchange.getOut().setHeader((String)entry.getKey(), entry.getValue());
            LOG.debug("Populate exchange from Restlet response header: {} value: {}", entry.getKey(), entry.getValue());
        }
        int responseCode = response.getStatus().getCode();
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)responseCode);
        exchange.getOut().setHeader("CamelRestletResponse", (Object)response);
        if (response.getEntity() != null) {
            MediaType mediaType = response.getEntity().getMediaType();
            if (mediaType != null) {
                exchange.getOut().setHeader("Content-Type", (Object)mediaType.toString());
            }
            String text = response.getEntity().getText();
            LOG.debug("Populate exchange from Restlet response: {}", (Object)text);
            exchange.getOut().setBody((Object)text);
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)false);
    }

    protected void setResponseHeader(Exchange exchange, org.restlet.Message message, String header, Object value) throws NoTypeConversionAvailableException {
        message.getAttributes().put(header, value);
        if (message.getEntity() != null) {
            Date date;
            if (header.equalsIgnoreCase("Expires")) {
                if (value instanceof Calendar) {
                    message.getEntity().setExpirationDate(((Calendar)value).getTime());
                } else if (value instanceof Date) {
                    message.getEntity().setExpirationDate((Date)value);
                } else {
                    date = (Date)exchange.getContext().getTypeConverter().mandatoryConvertTo(Date.class, value);
                    message.getEntity().setExpirationDate(date);
                }
            }
            if (header.equalsIgnoreCase("Last-Modified")) {
                if (value instanceof Calendar) {
                    message.getEntity().setModificationDate(((Calendar)value).getTime());
                } else if (value instanceof Date) {
                    message.getEntity().setModificationDate((Date)value);
                } else {
                    date = (Date)exchange.getContext().getTypeConverter().mandatoryConvertTo(Date.class, value);
                    message.getEntity().setModificationDate(date);
                }
            }
            if (header.equalsIgnoreCase("Content-Length")) {
                if (value instanceof Long) {
                    message.getEntity().setSize(((Long)value).longValue());
                } else if (value instanceof Integer) {
                    message.getEntity().setSize((long)((Integer)value).intValue());
                } else {
                    Long num = (Long)exchange.getContext().getTypeConverter().mandatoryConvertTo(Long.class, value);
                    message.getEntity().setSize(num.longValue());
                }
            }
            if (header.equalsIgnoreCase("Content-Type")) {
                if (value instanceof MediaType) {
                    message.getEntity().setMediaType((MediaType)value);
                } else {
                    String type = value.toString();
                    MediaType media = MediaType.valueOf((String)type);
                    if (media != null) {
                        message.getEntity().setMediaType(media);
                    } else {
                        LOG.debug("Value {} cannot be converted as a MediaType. The value will be ignored.", value);
                    }
                }
            }
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

