/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.apachehc;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.apachehc.ApacheHCUtils;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.rest.internal.RestAnnotationProcessor;

public class ApacheHCHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HttpUriRequest> {
    private final HttpClient client;

    @Inject
    ApacheHCHttpCommandExecutorService(HttpUtils utils, @Named(value="jclouds.io-worker-threads") ExecutorService ioWorkerExecutor, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, HttpClient client) {
        super(utils, ioWorkerExecutor, retryHandler, ioRetryHandler, errorHandler, wire);
        this.client = client;
    }

    protected HttpUriRequest convert(HttpRequest request) throws IOException {
        HttpUriRequest returnVal = ApacheHCUtils.convertToApacheRequest(request);
        if (request.getPayload() != null && request.getPayload().getContentMetadata().getContentMD5() != null) {
            returnVal.addHeader("Content-MD5", CryptoStreams.md5Base64((InputSupplier)request.getPayload()));
        }
        return returnVal;
    }

    protected HttpResponse invoke(HttpUriRequest nativeRequest) throws IOException {
        org.apache.http.HttpResponse apacheResponse = this.executeRequest(nativeRequest);
        InputStreamPayload payload = null;
        if (apacheResponse.getEntity() != null) {
            try {
                payload = Payloads.newInputStreamPayload((InputStream)ApacheHCHttpCommandExecutorService.consumeOnClose((InputStream)apacheResponse.getEntity().getContent()));
                if (apacheResponse.getEntity().getContentLength() >= 0L) {
                    payload.getContentMetadata().setContentLength(Long.valueOf(apacheResponse.getEntity().getContentLength()));
                }
                if (apacheResponse.getEntity().getContentType() != null) {
                    payload.getContentMetadata().setContentType(apacheResponse.getEntity().getContentType().getValue());
                }
            }
            catch (IOException e) {
                this.logger.warn((Throwable)e, "couldn't receive payload for request: %s", new Object[]{nativeRequest.getRequestLine()});
                throw e;
            }
        }
        LinkedHashMultimap headers = LinkedHashMultimap.create();
        for (Header header : apacheResponse.getAllHeaders()) {
            headers.put((Object)header.getName(), (Object)header.getValue());
        }
        if (payload != null) {
            payload.getContentMetadata().setPropertiesFromHttpHeaders((Multimap)headers);
        }
        return new HttpResponse(apacheResponse.getStatusLine().getStatusCode(), apacheResponse.getStatusLine().getReasonPhrase(), (Payload)payload, RestAnnotationProcessor.filterOutContentHeaders((Multimap)headers));
    }

    private org.apache.http.HttpResponse executeRequest(HttpUriRequest nativeRequest) throws IOException, ClientProtocolException {
        URI endpoint = URI.create(nativeRequest.getRequestLine().getUri());
        HttpHost host = new HttpHost(endpoint.getHost(), endpoint.getPort(), endpoint.getScheme());
        org.apache.http.HttpResponse nativeResponse = this.client.execute(host, (org.apache.http.HttpRequest)nativeRequest);
        return nativeResponse;
    }

    protected void cleanup(HttpUriRequest nativeResponse) {
    }
}

