/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.apachehc.config;

import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.TransformingHttpCommandExecutorService;
import org.jclouds.http.TransformingHttpCommandExecutorServiceImpl;
import org.jclouds.http.apachehc.ApacheHCHttpCommandExecutorService;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.SSLModule;
import org.jclouds.lifecycle.Closer;

@ConfiguresHttpCommandExecutorService
public class ApacheHCHttpCommandExecutorServiceModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new SSLModule());
        this.bindClient();
    }

    @Singleton
    @Provides
    HttpParams newBasicHttpParams(HttpUtils utils) {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", true).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"jclouds/1.0");
        if (utils.getConnectionTimeout() > 0) {
            params.setIntParameter("http.connection.timeout", utils.getConnectionTimeout());
        }
        if (utils.getSocketOpenTimeout() > 0) {
            params.setIntParameter("http.socket.timeout", utils.getSocketOpenTimeout());
        }
        if (utils.getMaxConnections() > 0) {
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)utils.getMaxConnections());
        }
        if (utils.getMaxConnectionsPerHost() > 0) {
            ConnPerRouteBean connectionsPerRoute = new ConnPerRouteBean(utils.getMaxConnectionsPerHost());
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connectionsPerRoute);
        }
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        return params;
    }

    @Singleton
    @Provides
    X509HostnameVerifier newHostnameVerifier(HttpUtils utils) {
        return utils.relaxHostname() ? SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    @Singleton
    @Provides
    SSLContext newSSLSocketFactory(HttpUtils utils, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider) throws NoSuchAlgorithmException, KeyManagementException {
        if (utils.trustAllCerts()) {
            return (SSLContext)untrustedSSLContextProvider.get();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        return context;
    }

    @Singleton
    @Provides
    ClientConnectionManager newClientConnectionManager(HttpParams params, X509HostnameVerifier verifier, SSLContext context, Closer closer) throws NoSuchAlgorithmException, KeyManagementException {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        Scheme http = new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80);
        SSLSocketFactory sf = new SSLSocketFactory(context);
        sf.setHostnameVerifier(verifier);
        Scheme https = new Scheme("https", (SocketFactory)sf, 443);
        SchemeRegistry sr = new SchemeRegistry();
        sr.register(http);
        sr.register(https);
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)sf, 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(params, schemeRegistry);
        closer.addToClose(new Closeable((ClientConnectionManager)cm){
            final /* synthetic */ ClientConnectionManager val$cm;
            {
                this.val$cm = clientConnectionManager;
            }

            @Override
            public void close() throws IOException {
                this.val$cm.shutdown();
            }
        });
        return cm;
    }

    @Provides
    @Singleton
    HttpClient newDefaultHttpClient(HttpUtils utils, BasicHttpParams params, ClientConnectionManager cm) {
        DefaultHttpClient client = new DefaultHttpClient(cm, (HttpParams)params);
        if (utils.useSystemProxies()) {
            ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
            client.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        return client;
    }

    protected void bindClient() {
        this.bind(HttpCommandExecutorService.class).to(ApacheHCHttpCommandExecutorService.class).in(Scopes.SINGLETON);
        this.bind(TransformingHttpCommandExecutorService.class).to(TransformingHttpCommandExecutorServiceImpl.class).in(Scopes.SINGLETON);
    }
}

