/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.JMException;
import org.apache.camel.component.quickfixj.MessageCorrelator;
import org.apache.camel.component.quickfixj.QuickfixjEventCategory;
import org.apache.camel.component.quickfixj.QuickfixjEventListener;
import org.apache.camel.util.ObjectHelper;
import org.quickfixj.jmx.JmxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.DoNotSend;
import quickfix.FieldConvertError;
import quickfix.FieldNotFound;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Initiator;
import quickfix.JdbcLogFactory;
import quickfix.JdbcStoreFactory;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RejectLogon;
import quickfix.SLF4JLogFactory;
import quickfix.ScreenLogFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SleepycatStoreFactory;
import quickfix.SocketAcceptor;
import quickfix.SocketInitiator;
import quickfix.ThreadedSocketAcceptor;
import quickfix.ThreadedSocketInitiator;
import quickfix.UnsupportedMessageType;

public class QuickfixjEngine {
    public static final String DEFAULT_START_TIME = "00:00:00";
    public static final String DEFAULT_END_TIME = "00:00:00";
    public static final long DEFAULT_HEARTBTINT = 30L;
    public static final String SETTING_THREAD_MODEL = "ThreadModel";
    public static final String SETTING_USE_JMX = "UseJmx";
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjEngine.class);
    private final Acceptor acceptor;
    private final Initiator initiator;
    private final JmxExporter jmxExporter;
    private final boolean forcedShutdown;
    private final MessageStoreFactory messageStoreFactory;
    private final LogFactory sessionLogFactory;
    private final MessageFactory messageFactory;
    private final MessageCorrelator messageCorrelator = new MessageCorrelator();
    private boolean started;
    private List<QuickfixjEventListener> eventListeners = new CopyOnWriteArrayList<QuickfixjEventListener>();
    private final String uri;

    public QuickfixjEngine(String uri, String settingsResourceName, boolean forcedShutdown) throws ConfigError, FieldConvertError, IOException, JMException {
        this(uri, settingsResourceName, forcedShutdown, null, null, null);
    }

    public QuickfixjEngine(String uri, String settingsResourceName, boolean forcedShutdown, MessageStoreFactory messageStoreFactoryOverride, LogFactory sessionLogFactoryOverride, MessageFactory messageFactoryOverride) throws ConfigError, FieldConvertError, IOException, JMException {
        this(uri, QuickfixjEngine.loadSettings(settingsResourceName), forcedShutdown, messageStoreFactoryOverride, sessionLogFactoryOverride, messageFactoryOverride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuickfixjEngine(String uri, SessionSettings settings, boolean forcedShutdown, MessageStoreFactory messageStoreFactoryOverride, LogFactory sessionLogFactoryOverride, MessageFactory messageFactoryOverride) throws ConfigError, FieldConvertError, IOException, JMException {
        this.addEventListener(this.messageCorrelator);
        this.uri = uri;
        this.forcedShutdown = forcedShutdown;
        this.messageFactory = messageFactoryOverride != null ? messageFactoryOverride : new DefaultMessageFactory();
        this.sessionLogFactory = sessionLogFactoryOverride != null ? sessionLogFactoryOverride : this.inferLogFactory(settings);
        MessageStoreFactory messageStoreFactory = this.messageStoreFactory = messageStoreFactoryOverride != null ? messageStoreFactoryOverride : this.inferMessageStoreFactory(settings);
        if (!settings.isSetting("StartTime")) {
            settings.setString("StartTime", "00:00:00");
        }
        if (!settings.isSetting("EndTime")) {
            settings.setString("EndTime", "00:00:00");
        }
        if (!settings.isSetting("HeartBtInt")) {
            settings.setLong("HeartBtInt", 30L);
        }
        ThreadModel threadModel = ThreadModel.ThreadPerConnector;
        if (settings.isSetting(SETTING_THREAD_MODEL)) {
            threadModel = ThreadModel.valueOf(settings.getString(SETTING_THREAD_MODEL));
        }
        if (settings.isSetting(SETTING_USE_JMX) && settings.getBool(SETTING_USE_JMX)) {
            LOG.info("Enabling JMX for QuickFIX/J");
            this.jmxExporter = new JmxExporter();
        } else {
            this.jmxExporter = null;
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.acceptor = this.isConnectorRole(settings, "acceptor") ? this.createAcceptor(new Dispatcher(), settings, this.messageStoreFactory, this.sessionLogFactory, this.messageFactory, threadModel) : null;
            this.initiator = this.isConnectorRole(settings, "initiator") ? this.createInitiator(new Dispatcher(), settings, this.messageStoreFactory, this.sessionLogFactory, this.messageFactory, threadModel) : null;
            if (this.acceptor == null && this.initiator == null) {
                throw new ConfigError("No connector role");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private static SessionSettings loadSettings(String settingsResourceName) throws ConfigError {
        InputStream inputStream = ObjectHelper.loadResourceAsStream((String)settingsResourceName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not load " + settingsResourceName);
        }
        return new SessionSettings(inputStream);
    }

    public void start() throws Exception {
        if (this.acceptor != null) {
            this.acceptor.start();
            if (this.jmxExporter != null) {
                this.jmxExporter.register((Connector)this.acceptor);
            }
        }
        if (this.initiator != null) {
            this.initiator.start();
            if (this.jmxExporter != null) {
                this.jmxExporter.register((Connector)this.initiator);
            }
        }
        this.started = true;
    }

    public void stop() throws Exception {
        this.stop(this.forcedShutdown);
    }

    public void stop(boolean force) throws Exception {
        if (this.acceptor != null) {
            this.acceptor.stop();
        }
        if (this.initiator != null) {
            this.initiator.stop();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    private Initiator createInitiator(Application application, SessionSettings settings, MessageStoreFactory messageStoreFactory, LogFactory sessionLogFactory, MessageFactory messageFactory, ThreadModel threadModel) throws ConfigError {
        ThreadedSocketInitiator initiator;
        if (threadModel == ThreadModel.ThreadPerSession) {
            initiator = new ThreadedSocketInitiator(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else if (threadModel == ThreadModel.ThreadPerConnector) {
            initiator = new SocketInitiator(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else {
            throw new ConfigError("Unknown thread mode: " + (Object)((Object)threadModel));
        }
        return initiator;
    }

    private Acceptor createAcceptor(Application application, SessionSettings settings, MessageStoreFactory messageStoreFactory, LogFactory sessionLogFactory, MessageFactory messageFactory, ThreadModel threadModel) throws ConfigError {
        ThreadedSocketAcceptor acceptor;
        if (threadModel == ThreadModel.ThreadPerSession) {
            acceptor = new ThreadedSocketAcceptor(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else if (threadModel == ThreadModel.ThreadPerConnector) {
            acceptor = new SocketAcceptor(application, messageStoreFactory, settings, sessionLogFactory, messageFactory);
        } else {
            throw new ConfigError("Unknown thread mode: " + (Object)((Object)threadModel));
        }
        return acceptor;
    }

    private MessageStoreFactory inferMessageStoreFactory(SessionSettings settings) throws ConfigError {
        HashSet<MessageStoreFactory> impliedMessageStoreFactories = new HashSet<MessageStoreFactory>();
        this.isJdbcStore(settings, impliedMessageStoreFactories);
        this.isFileStore(settings, impliedMessageStoreFactories);
        this.isSleepycatStore(settings, impliedMessageStoreFactories);
        if (impliedMessageStoreFactories.size() > 1) {
            throw new ConfigError("Ambiguous message store implied in configuration.");
        }
        Object messageStoreFactory = impliedMessageStoreFactories.size() == 1 ? (MessageStoreFactory)impliedMessageStoreFactories.iterator().next() : new MemoryStoreFactory();
        LOG.info("Inferring message store factory: " + messageStoreFactory.getClass().getName());
        return messageStoreFactory;
    }

    private void isSleepycatStore(SessionSettings settings, Set<MessageStoreFactory> impliedMessageStoreFactories) {
        if (settings.isSetting("SleepycatDatabaseDir")) {
            impliedMessageStoreFactories.add((MessageStoreFactory)new SleepycatStoreFactory(settings));
        }
    }

    private void isFileStore(SessionSettings settings, Set<MessageStoreFactory> impliedMessageStoreFactories) {
        if (settings.isSetting("FileStorePath")) {
            impliedMessageStoreFactories.add((MessageStoreFactory)new FileStoreFactory(settings));
        }
    }

    private void isJdbcStore(SessionSettings settings, Set<MessageStoreFactory> impliedMessageStoreFactories) {
        if (settings.isSetting("JdbcDriver") || settings.isSetting("JdbcDataSourceName")) {
            impliedMessageStoreFactories.add((MessageStoreFactory)new JdbcStoreFactory(settings));
        }
    }

    private LogFactory inferLogFactory(SessionSettings settings) throws ConfigError {
        HashSet<LogFactory> impliedLogFactories = new HashSet<LogFactory>();
        this.isFileLog(settings, impliedLogFactories);
        this.isScreenLog(settings, impliedLogFactories);
        this.isSL4JLog(settings, impliedLogFactories);
        this.isJdbcLog(settings, impliedLogFactories);
        if (impliedLogFactories.size() > 1) {
            throw new ConfigError("Ambiguous log factory implied in configuration");
        }
        Object sessionLogFactory = impliedLogFactories.size() == 1 ? (LogFactory)impliedLogFactories.iterator().next() : new ScreenLogFactory(settings);
        LOG.info("Inferring log factory: " + sessionLogFactory.getClass().getName());
        return sessionLogFactory;
    }

    private void isScreenLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        if (settings.isSetting("ScreenLogShowEvents") || settings.isSetting("ScreenLogShowIncoming") || settings.isSetting("ScreenLogShowOutgoing")) {
            impliedLogFactories.add((LogFactory)new ScreenLogFactory(settings));
        }
    }

    private void isFileLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        if (settings.isSetting("FileLogPath")) {
            impliedLogFactories.add((LogFactory)new FileLogFactory(settings));
        }
    }

    private void isJdbcLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        if ((settings.isSetting("JdbcDriver") || settings.isSetting("JdbcDataSourceName")) && settings.isSetting("JdbcLogEventTable")) {
            impliedLogFactories.add((LogFactory)new JdbcLogFactory(settings));
        }
    }

    private void isSL4JLog(SessionSettings settings, Set<LogFactory> impliedLogFactories) {
        for (Object key : settings.getDefaultProperties().keySet()) {
            if (!key.toString().startsWith("SLF4J")) continue;
            impliedLogFactories.add((LogFactory)new SLF4JLogFactory(settings));
            return;
        }
    }

    private boolean isConnectorRole(SessionSettings settings, String connectorRole) throws ConfigError {
        boolean hasRole = false;
        Iterator sessionIdItr = settings.sectionIterator();
        while (sessionIdItr.hasNext()) {
            try {
                if (!connectorRole.equals(settings.getString((SessionID)sessionIdItr.next(), "ConnectionType"))) continue;
                hasRole = true;
                break;
            }
            catch (FieldConvertError e) {
                throw new ConfigError((Throwable)e);
            }
        }
        return hasRole;
    }

    public void addEventListener(QuickfixjEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(QuickfixjEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public String getUri() {
        return this.uri;
    }

    public MessageCorrelator getMessageCorrelator() {
        return this.messageCorrelator;
    }

    Initiator getInitiator() {
        return this.initiator;
    }

    Acceptor getAcceptor() {
        return this.acceptor;
    }

    MessageStoreFactory getMessageStoreFactory() {
        return this.messageStoreFactory;
    }

    LogFactory getLogFactory() {
        return this.sessionLogFactory;
    }

    MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    private class Dispatcher
    implements Application {
        private Dispatcher() {
        }

        public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
            try {
                this.dispatch(QuickfixjEventCategory.AdminMessageReceived, sessionID, message);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.rethrowIfType(e, FieldNotFound.class);
                this.rethrowIfType(e, IncorrectDataFormat.class);
                this.rethrowIfType(e, IncorrectTagValue.class);
                this.rethrowIfType(e, RejectLogon.class);
                throw new DispatcherException((Throwable)e);
            }
        }

        public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
            try {
                this.dispatch(QuickfixjEventCategory.AppMessageReceived, sessionID, message);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.rethrowIfType(e, FieldNotFound.class);
                this.rethrowIfType(e, IncorrectDataFormat.class);
                this.rethrowIfType(e, IncorrectTagValue.class);
                this.rethrowIfType(e, UnsupportedMessageType.class);
                throw new DispatcherException((Throwable)e);
            }
        }

        public void onCreate(SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.SessionCreated, sessionID, null);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void onLogon(SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.SessionLogon, sessionID, null);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void onLogout(SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.SessionLogoff, sessionID, null);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void toAdmin(Message message, SessionID sessionID) {
            try {
                this.dispatch(QuickfixjEventCategory.AdminMessageSent, sessionID, message);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        public void toApp(Message message, SessionID sessionID) throws DoNotSend {
            try {
                this.dispatch(QuickfixjEventCategory.AppMessageSent, sessionID, message);
            }
            catch (Exception e) {
                throw new DispatcherException((Throwable)e);
            }
        }

        private <T extends Exception> void rethrowIfType(Exception e, Class<T> exceptionClass) throws T {
            throw e;
        }

        private void dispatch(QuickfixjEventCategory quickfixjEventCategory, SessionID sessionID, Message message) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("FIX event dispatched: {} {}", (Object)quickfixjEventCategory, message != null ? message : "");
            }
            for (QuickfixjEventListener listener : QuickfixjEngine.this.eventListeners) {
                listener.onEvent(quickfixjEventCategory, sessionID, message);
            }
        }

        private class DispatcherException
        extends RuntimeException {
            public DispatcherException(Throwable cause) {
                super(cause);
            }
        }
    }

    public static enum ThreadModel {
        ThreadPerConnector,
        ThreadPerSession;

    }
}

