/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperConnectionManager;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.camel.component.zookeeper.ZooKeeperMessage;
import org.apache.camel.component.zookeeper.operations.AnyOfOperations;
import org.apache.camel.component.zookeeper.operations.ChildrenChangedOperation;
import org.apache.camel.component.zookeeper.operations.DataChangedOperation;
import org.apache.camel.component.zookeeper.operations.ExistenceChangedOperation;
import org.apache.camel.component.zookeeper.operations.ExistsOperation;
import org.apache.camel.component.zookeeper.operations.GetChildrenOperation;
import org.apache.camel.component.zookeeper.operations.GetDataOperation;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperConsumer
extends DefaultConsumer {
    private ZooKeeperConnectionManager connectionManager;
    private ZooKeeper connection;
    private ZooKeeperConfiguration configuration;
    private LinkedBlockingQueue<ZooKeeperOperation> operations = new LinkedBlockingQueue();
    private boolean shuttingDown;
    private ExecutorService executor;

    public ZooKeeperConsumer(ZooKeeperEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.connectionManager = endpoint.getConnectionManager();
        this.configuration = endpoint.getConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connection = this.connectionManager.getConnection();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Connected to Zookeeper cluster %s", this.configuration.getConnectString()));
        }
        this.initializeConsumer();
        this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this.configuration.getPath(), "Camel-Zookeeper Ops executor", 1);
        OperationsExecutor opsService = new OperationsExecutor();
        this.executor.execute(opsService);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.shuttingDown = true;
        this.connection = this.connectionManager.getConnection();
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("Shutting down zookeeper consumer of '%s'", this.configuration.getPath()));
        }
        this.executor.shutdown();
        this.connectionManager.shutdown();
    }

    private void initializeConsumer() {
        String node = this.configuration.getPath();
        if (this.configuration.listChildren()) {
            this.initializeChildListingConsumer(node);
        } else {
            this.initializeDataConsumer(node);
        }
    }

    private void initializeDataConsumer(String node) {
        if (!this.shuttingDown) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Initailizing consumption of data on node '%s'", node));
            }
            this.addBasicDataConsumeSequence(node);
        }
    }

    private void initializeChildListingConsumer(String node) {
        if (!this.shuttingDown) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Initailizing child listing of node '%s'", node));
            }
            this.addBasicChildListingSequence(node);
        }
    }

    private Exchange createExchange(String path, OperationResult result) {
        Exchange e = this.getEndpoint().createExchange();
        ZooKeeperMessage in = new ZooKeeperMessage(path, result.getStatistics());
        e.setIn((Message)in);
        if (result.isOk()) {
            in.setBody(result.getResult());
        } else {
            e.setException((Throwable)result.getException());
        }
        return e;
    }

    private void addBasicDataConsumeSequence(String node) {
        this.operations.clear();
        this.operations.add(new AnyOfOperations(node, new ExistsOperation(this.connection, node), new ExistenceChangedOperation(this.connection, node)));
        this.operations.add(new GetDataOperation(this.connection, node));
        this.operations.add(new DataChangedOperation(this.connection, node, false));
    }

    private void addBasicChildListingSequence(String node) {
        this.operations.clear();
        this.operations.add(new AnyOfOperations(node, new ExistsOperation(this.connection, node), new ExistenceChangedOperation(this.connection, node)));
        this.operations.add(new GetChildrenOperation(this.connection, node));
        this.operations.add(new ChildrenChangedOperation(this.connection, node, false));
    }

    private class OperationsExecutor
    implements Runnable {
        private ZooKeeperOperation current;

        private OperationsExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ZooKeeperConsumer.this.isRunAllowed()) {
                block14: {
                    try {
                        this.current = (ZooKeeperOperation)ZooKeeperConsumer.this.operations.take();
                        if (!ZooKeeperConsumer.this.log.isTraceEnabled()) break block14;
                        ZooKeeperConsumer.this.log.trace(String.format("Processing '%s' operation", this.current.getClass().getSimpleName()));
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                String node = this.current.getNode();
                try {
                    OperationResult result = this.current.get();
                    if (result == null || !this.current.shouldProduceExchange()) continue;
                    ZooKeeperConsumer.this.getProcessor().process(ZooKeeperConsumer.this.createExchange(node, result));
                }
                catch (Exception e) {
                    ZooKeeperConsumer.this.handleException(e);
                    this.backoffAndThenRestart();
                }
                finally {
                    if (!ZooKeeperConsumer.this.configuration.shouldRepeat()) continue;
                    try {
                        ZooKeeperConsumer.this.operations.offer(this.current.createCopy());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.backoffAndThenRestart();
                    }
                }
            }
        }

        private void backoffAndThenRestart() {
            try {
                if (ZooKeeperConsumer.this.isRunAllowed()) {
                    Thread.sleep(ZooKeeperConsumer.this.configuration.getBackoff());
                    ZooKeeperConsumer.this.initializeConsumer();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

