/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.zookeeper.ZooKeeperComponent;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperConnectionManager;
import org.apache.camel.component.zookeeper.ZooKeeperConsumer;
import org.apache.camel.component.zookeeper.ZookeeperProducer;
import org.apache.camel.impl.DefaultEndpoint;

@ManagedResource(description="ZooKeeper Endpoint")
public class ZooKeeperEndpoint
extends DefaultEndpoint {
    private ZooKeeperConfiguration configuration;
    private ZooKeeperConnectionManager connectionManager;

    public ZooKeeperEndpoint(String uri, ZooKeeperComponent component, ZooKeeperConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.connectionManager = new ZooKeeperConnectionManager(this);
    }

    public Producer createProducer() throws Exception {
        return new ZookeeperProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ZooKeeperConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public void setConfiguration(ZooKeeperConfiguration configuration) {
        this.configuration = configuration;
    }

    public ZooKeeperConfiguration getConfiguration() {
        return this.configuration;
    }

    ZooKeeperConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @ManagedAttribute(description="Session Password")
    public byte[] getSessionPassword() {
        return this.getConfiguration().getSessionPassword();
    }

    @ManagedAttribute
    public int getSessionId() {
        return this.getConfiguration().getSessionId();
    }

    @ManagedAttribute
    public void setPath(String path) {
        this.getConfiguration().setPath(path);
    }

    @ManagedAttribute
    public String getPath() {
        return this.getConfiguration().getPath();
    }

    @ManagedAttribute
    public int getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    @ManagedAttribute
    public void setTimeout(int timeout) {
        this.getConfiguration().setTimeout(timeout);
    }

    @ManagedAttribute
    public boolean getRepeat() {
        return this.getConfiguration().shouldRepeat();
    }

    @ManagedAttribute
    public void setRepeat(boolean shouldRepeat) {
        this.getConfiguration().setRepeat(shouldRepeat);
    }

    @ManagedAttribute
    public List<String> getServers() {
        return this.getConfiguration().getServers();
    }

    @ManagedAttribute
    public void setServers(List<String> servers) {
        this.getConfiguration().setServers(servers);
    }

    @ManagedAttribute
    public boolean getListChildren() {
        return this.getConfiguration().listChildren();
    }

    @ManagedAttribute
    public void setListChildren(boolean listChildren) {
        this.getConfiguration().setListChildren(listChildren);
    }

    @ManagedAttribute
    public boolean getCreate() {
        return this.getConfiguration().shouldCreate();
    }

    @ManagedAttribute
    public void setCreate(boolean shouldCreate) {
        this.getConfiguration().setCreate(shouldCreate);
    }

    @ManagedAttribute
    public long getBackoff() {
        return this.getConfiguration().getBackoff();
    }

    @ManagedAttribute
    public void setBackoff(long backoff) {
        this.getConfiguration().setBackoff(backoff);
    }

    @ManagedAttribute
    public boolean getAwaitExistence() {
        return this.getConfiguration().shouldAwaitExistence();
    }

    @ManagedAttribute
    public void setAwaitExistence(boolean awaitExistence) {
        this.getConfiguration().setAwaitExistance(awaitExistence);
    }

    @ManagedOperation
    public void addServer(String server) {
        this.getConfiguration().addZookeeperServer(server);
    }

    @ManagedOperation
    public void clearServers() {
        this.getConfiguration().getServers().clear();
    }

    public Object getManagedObject(ZooKeeperEndpoint arg0) {
        return this;
    }
}

