/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;

public class AnyOfOperations
extends ZooKeeperOperation {
    private ZooKeeperOperation[] keeperOperations;

    public AnyOfOperations(String node, ZooKeeperOperation ... keeperOperations) {
        super(null, node, false);
        this.keeperOperations = keeperOperations;
    }

    public OperationResult get() throws InterruptedException, ExecutionException {
        for (ZooKeeperOperation op : this.keeperOperations) {
            try {
                OperationResult result = op.get();
                if (!result.isOk()) continue;
                return result;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new ExecutionException("All operations exhausted without one result", null);
    }

    public OperationResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    public OperationResult getResult() {
        return null;
    }

    @Override
    public ZooKeeperOperation createCopy() throws Exception {
        ZooKeeperOperation[] copy = new ZooKeeperOperation[this.keeperOperations.length];
        for (int x = 0; x < this.keeperOperations.length; ++x) {
            copy[x] = this.keeperOperations[x].createCopy();
        }
        return new AnyOfOperations(this.node, copy);
    }
}

