/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.camel.component.zookeeper.operations.FutureEventDrivenOperation;
import org.apache.camel.component.zookeeper.operations.GetDataOperation;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class DataChangedOperation
extends FutureEventDrivenOperation<byte[]> {
    protected static final Class[] CONSTRUCTOR_ARGS = new Class[]{ZooKeeper.class, String.class, Boolean.TYPE};
    private boolean getChangedData;

    public DataChangedOperation(ZooKeeper connection, String znode, boolean getChangedData) {
        super(connection, znode, Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeDeleted);
        this.getChangedData = getChangedData;
    }

    @Override
    protected void installWatch() {
        this.connection.getData(this.getNode(), (Watcher)this, new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            }
        }, null);
    }

    @Override
    public OperationResult<byte[]> getResult() {
        return this.getChangedData ? new GetDataOperation(this.connection, this.getNode()).getResult() : null;
    }

    @Override
    public ZooKeeperOperation createCopy() throws Exception {
        return (ZooKeeperOperation)this.getClass().getConstructor(CONSTRUCTOR_ARGS).newInstance(this.connection, this.node, this.getChangedData);
    }
}

