/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.policy;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.zookeeper.SequenceComparator;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.camel.impl.JavaUuidGenerator;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.ExchangeHelper;
import org.apache.zookeeper.CreateMode;

public class ZooKeeperRoutePolicy
extends RoutePolicySupport {
    private String uri;
    private int enabledCount;
    private String candidateName;
    private final Lock lock = new ReentrantLock();
    private final CountDownLatch electionComplete = new CountDownLatch(1);
    private Set<Route> suspendedRoutes = new CopyOnWriteArraySet<Route>();
    private AtomicBoolean shouldProcessExchanges = new AtomicBoolean();
    private ProducerTemplate template;
    private boolean shouldStopConsumer = true;
    private UuidGenerator uuidGenerator = new JavaUuidGenerator();
    private boolean isCandidateCreated;

    public ZooKeeperRoutePolicy(String uri, int enabledCount) throws Exception {
        this.uri = uri;
        this.enabledCount = enabledCount;
        this.createCandidateName();
    }

    private void createCandidateName() throws Exception {
        StringBuilder b = new StringBuilder(InetAddress.getLocalHost().getCanonicalHostName());
        b.append("-").append(this.uuidGenerator.generateUuid());
        this.candidateName = b.toString();
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
        this.testAndCreateCandidateNode(route);
        this.awaitElectionResults();
        if (!this.shouldProcessExchanges.get()) {
            if (this.shouldStopConsumer) {
                this.stopConsumer(route);
            }
            IllegalStateException e = new IllegalStateException("Zookeeper based route policy prohibits processing exchanges, stopping route and failing the exchange");
            exchange.setException((Throwable)e);
        } else if (this.shouldStopConsumer) {
            this.startConsumer(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndCreateCandidateNode(Route route) {
        try {
            this.lock.lock();
            if (!this.isCandidateCreated) {
                this.createCandidateNode(route.getRouteContext().getCamelContext());
                this.isCandidateCreated = true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitElectionResults() {
        while (this.electionComplete.getCount() > 0L) {
            try {
                this.electionComplete.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConsumer(Route route) {
        try {
            this.lock.lock();
            if (this.suspendedRoutes.contains(route)) {
                this.startConsumer(route.getConsumer());
                this.suspendedRoutes.remove(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConsumer(Route route) {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.contains(route) && !this.shouldProcessExchanges.get()) {
                this.stopConsumer(route.getConsumer());
                this.suspendedRoutes.add(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllStoppedConsumers() {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("'%d' have been stopped previously by poilcy, restarting.", this.suspendedRoutes.size()));
                }
                for (Route suspended : this.suspendedRoutes) {
                    this.startConsumer(suspended.getConsumer());
                }
                this.suspendedRoutes.clear();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isShouldStopConsumer() {
        return this.shouldStopConsumer;
    }

    public void setShouldStopConsumer(boolean shouldStopConsumer) {
        this.shouldStopConsumer = shouldStopConsumer;
    }

    private ZooKeeperEndpoint createCandidateNode(CamelContext camelContext) {
        this.template = camelContext.createProducerTemplate();
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Initializing ZookeeperRoutePolicy with uri '%s'", this.uri));
        }
        ZooKeeperEndpoint zep = (ZooKeeperEndpoint)camelContext.getEndpoint(this.uri, ZooKeeperEndpoint.class);
        zep.getConfiguration().setCreate(true);
        String fullpath = this.createFullPathToCandidate(zep);
        Exchange e = zep.createExchange();
        e.setPattern(ExchangePattern.InOut);
        e.getIn().setHeader("CamelZooKeeperNode", (Object)fullpath);
        e.getIn().setHeader("CamelZookeeperCreateMode", (Object)CreateMode.EPHEMERAL_SEQUENTIAL);
        this.template.send((Endpoint)zep, e);
        if (e.isFailed()) {
            this.log.error("Error setting up election node " + fullpath, (Throwable)e.getException());
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info(String.format("Candidate node '%s' has been created", fullpath));
            }
            try {
                if (zep != null) {
                    camelContext.addRoutes((RoutesBuilder)new ElectoralMonitorRoute(zep));
                }
            }
            catch (Exception ex) {
                this.log.error("Error configuring ZookeeperRoutePolicy", (Throwable)ex);
            }
        }
        return zep;
    }

    private String createFullPathToCandidate(ZooKeeperEndpoint zep) {
        String fullpath = zep.getConfiguration().getPath();
        if (!fullpath.endsWith("/")) {
            fullpath = fullpath + "/";
        }
        fullpath = fullpath + this.candidateName;
        return fullpath;
    }

    private class ElectoralMonitorRoute
    extends RouteBuilder {
        private SequenceComparator comparator = new SequenceComparator();
        private ZooKeeperEndpoint zep;

        public ElectoralMonitorRoute(ZooKeeperEndpoint zep) {
            this.zep = zep;
            zep.getConfiguration().setListChildren(true);
            zep.getConfiguration().setRepeat(true);
        }

        public void configure() throws Exception {
            ((RouteDefinition)this.from((Endpoint)this.zep).sort((Expression)this.body(), (Comparator)this.comparator)).process(new Processor(){

                public void process(Exchange e) throws Exception {
                    int location;
                    List candidates = (List)ExchangeHelper.getMandatoryInBody((Exchange)e);
                    if (this.isOurCandidateAtLocationInCandidatesList(candidates, location = Math.abs(Collections.binarySearch(candidates, ZooKeeperRoutePolicy.this.candidateName)))) {
                        ZooKeeperRoutePolicy.this.shouldProcessExchanges.set(location <= ZooKeeperRoutePolicy.this.enabledCount);
                        if (ElectoralMonitorRoute.this.log.isDebugEnabled()) {
                            ElectoralMonitorRoute.this.log.debug(String.format("This node is number '%d' on the candidate list, route is configured for the top '%d'. Exchange processing will be %s", location, ZooKeeperRoutePolicy.this.enabledCount, ZooKeeperRoutePolicy.this.shouldProcessExchanges.get() ? "enabled" : "disabled"));
                        }
                        ZooKeeperRoutePolicy.this.startAllStoppedConsumers();
                    }
                    ZooKeeperRoutePolicy.this.electionComplete.countDown();
                }

                private boolean isOurCandidateAtLocationInCandidatesList(List<String> candidates, int location) {
                    return location <= candidates.size() && candidates.get(location - 1).startsWith(ZooKeeperRoutePolicy.this.candidateName);
                }
            });
        }
    }
}

