/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.compute.strategy;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.openstack.nova.NovaClient;
import org.jclouds.openstack.nova.domain.Flavor;
import org.jclouds.openstack.nova.domain.Image;
import org.jclouds.openstack.nova.domain.RebootType;
import org.jclouds.openstack.nova.domain.Server;
import org.jclouds.openstack.nova.options.CreateServerOptions;
import org.jclouds.openstack.nova.options.ListOptions;

@Singleton
public class NovaComputeServiceAdapter
implements ComputeServiceAdapter<Server, Flavor, Image, Location> {
    protected final NovaClient client;
    protected final JustProvider locationSupplier;

    @Inject
    protected NovaComputeServiceAdapter(NovaClient client, JustProvider locationSupplier) {
        this.client = (NovaClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.locationSupplier = (JustProvider)Preconditions.checkNotNull((Object)locationSupplier, (Object)"locationSupplier");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Server server = this.client.createServer(name, template.getImage().getId(), template.getHardware().getId(), CreateServerOptions.Builder.withMetadata(template.getOptions().getUserMetadata()));
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)server, server.getId() + "", LoginCredentials.builder().password(server.getAdminPass()).build());
    }

    public Iterable<Flavor> listHardwareProfiles() {
        return this.client.listFlavors(ListOptions.Builder.withDetails());
    }

    public Iterable<Image> listImages() {
        return this.client.listImages(ListOptions.Builder.withDetails());
    }

    public Iterable<Server> listNodes() {
        return this.client.listServers(ListOptions.Builder.withDetails());
    }

    public Iterable<Location> listLocations() {
        return this.locationSupplier.get();
    }

    public Server getNode(String id) {
        int serverId = Integer.parseInt(id);
        return this.client.getServer(serverId);
    }

    public void destroyNode(String id) {
        int serverId = Integer.parseInt(id);
        this.client.deleteServer(serverId);
    }

    public void rebootNode(String id) {
        int serverId = Integer.parseInt(id);
        this.client.rebootServer(serverId, RebootType.HARD);
    }

    public void resumeNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }

    public void suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }
}

